"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.hasTags = void 0;
const tslib_1 = require("tslib");
const npmlog_1 = tslib_1.__importDefault(require("npmlog"));
const child_process_1 = require("../../../child-process");
/**
 * Determine if any git tags are reachable.
 * @param {import("@lerna/child-process").ExecOpts} opts
 * @param {string} tagPattern
 */
function hasTags(opts, tagPattern) {
    npmlog_1.default.silly('hasTags', '');
    let result = false;
    const args = ['tag'];
    if (tagPattern) {
        npmlog_1.default.verbose('hasTags', `filter for tags with '${tagPattern}' pattern`);
        args.push('--list', tagPattern);
    }
    try {
        result = !!(0, child_process_1.execSync)('git', args, opts);
    }
    catch (err) {
        npmlog_1.default.warn('ENOTAGS', 'No git tags were reachable from this branch!');
        npmlog_1.default.verbose('hasTags error', err);
    }
    npmlog_1.default.verbose('hasTags', result.toString());
    return result;
}
exports.hasTags = hasTags;
//# sourceMappingURL=has-tags.js.map