"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.collectPackages = void 0;
const collect_dependents_1 = require("./collect-dependents");
/**
 * Build a list of graph nodes, possibly including dependents, using predicate if available.
 * @param {Map<string, import("@lerna/package-graph").PackageGraphNode>} packages
 * @param {PackageCollectorOptions} options
 */
function collectPackages(packages, { isCandidate = () => true, onInclude, excludeDependents } = {}) {
    /** @type {Set<import("@lerna/package-graph").PackageGraphNode>} */
    const candidates = new Set();
    packages.forEach((node, name) => {
        if (isCandidate(node, name)) {
            candidates.add(node);
        }
    });
    if (!excludeDependents) {
        (0, collect_dependents_1.collectDependents)(candidates).forEach((node) => candidates.add(node));
    }
    // The result should always be in the same order as the input
    const updates = [];
    packages.forEach((node, name) => {
        if (candidates.has(node)) {
            if (onInclude) {
                onInclude(name);
            }
            updates.push(node);
        }
    });
    return updates;
}
exports.collectPackages = collectPackages;
//# sourceMappingURL=collect-packages.js.map