import { PackageGraphNode } from '../../../package-graph/lib/package-graph-node';
interface PackageCollectorOptions {
    isCandidate?: (node: PackageGraphNode, name: string) => boolean;
    onInclude?: (name: string) => void;
    excludeDependents?: boolean;
}
/**
 * Build a list of graph nodes, possibly including dependents, using predicate if available.
 * @param {Map<string, import("@lerna/package-graph").PackageGraphNode>} packages
 * @param {PackageCollectorOptions} options
 */
export declare function collectPackages(packages: any, { isCandidate, onInclude, excludeDependents }?: PackageCollectorOptions): PackageGraphNode[];
export {};
