"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.collectUncommittedSync = exports.collectUncommitted = void 0;
const tslib_1 = require("tslib");
const chalk_1 = tslib_1.__importDefault(require("chalk"));
const npmlog_1 = tslib_1.__importDefault(require("npmlog"));
const child_process_1 = require("../child-process");
const maybeColorize = (colorize) => (s) => s !== ' ' ? colorize(s) : s;
const cRed = maybeColorize(chalk_1.default.red);
const cGreen = maybeColorize(chalk_1.default.green);
const colorizeStats = (stats) => stats.replace(/^([^U]| )([A-Z]| )/gm, replaceStatus).replace(/^\?{2}|U{2}/gm, cRed('$&'));
const replaceStatus = (_, maybeGreen, maybeRed) => `${cGreen(maybeGreen)}${cRed(maybeRed)}`;
const splitOnNewLine = (str) => str.split('\n');
const filterEmpty = (lines) => lines.filter((line) => line.length);
const o = (l, r) => (x) => l(r(x));
const transformOutput = o(filterEmpty, o(splitOnNewLine, colorizeStats));
/**
 * Report uncommitted files. (async)
 * @param {UncommittedConfig} options
 * @returns {Promise<string[]>} A list of uncommitted files
 */
function collectUncommitted({ cwd, log = npmlog_1.default }, dryRun = false) {
    log.silly('collect-uncommitted', 'git status --porcelain (async)');
    return (0, child_process_1.exec)('git', ['status', '--porcelain'], { cwd }, dryRun).then(({ stdout }) => transformOutput(stdout));
}
exports.collectUncommitted = collectUncommitted;
/**
 * Report uncommitted files. (sync)
 * @param {UncommittedConfig} options
 * @returns {string[]} A list of uncommitted files
 */
function collectUncommittedSync({ cwd, log = npmlog_1.default }, dryRun = false) {
    log.silly('collect-uncommitted', 'git status --porcelain (sync)');
    const stdout = (0, child_process_1.execSync)('git', ['status', '--porcelain'], { cwd }, dryRun);
    return transformOutput(stdout);
}
exports.collectUncommittedSync = collectUncommittedSync;
//# sourceMappingURL=collect-uncommitted.js.map