import npmlog from 'npmlog';
export interface UncommittedConfig {
    cwd: string;
    log?: typeof npmlog;
}
/**
 * Report uncommitted files. (async)
 * @param {UncommittedConfig} options
 * @returns {Promise<string[]>} A list of uncommitted files
 */
export declare function collectUncommitted({ cwd, log }: UncommittedConfig, dryRun?: boolean): Promise<string[]>;
/**
 * Report uncommitted files. (sync)
 * @param {UncommittedConfig} options
 * @returns {string[]} A list of uncommitted files
 */
export declare function collectUncommittedSync({ cwd, log }: UncommittedConfig, dryRun?: boolean): string[];
