"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.promptTextInput = exports.promptSelectOne = exports.promptConfirmation = void 0;
const tslib_1 = require("tslib");
const inquirer_1 = tslib_1.__importDefault(require("inquirer"));
const npmlog_1 = tslib_1.__importDefault(require("npmlog"));
/**
 * Prompt for confirmation
 * @param {string} message
 * @returns {Promise<boolean>}
 */
async function promptConfirmation(message) {
    npmlog_1.default.pause();
    const answers = await inquirer_1.default.prompt([
        {
            type: 'expand',
            name: 'confirm',
            message,
            default: 2,
            choices: [
                { key: 'y', name: 'Yes', value: true },
                { key: 'n', name: 'No', value: false },
            ],
        },
    ]);
    npmlog_1.default.resume();
    return answers.confirm;
}
exports.promptConfirmation = promptConfirmation;
/**
 * Prompt for selection
 * @param {string} message
 * @param {{ choices: import("inquirer").ListChoiceOptions[] } & Pick<import("inquirer").Question, 'filter' | 'validate'>} [options]
 * @returns {Promise<string>}
 */
async function promptSelectOne(message, { choices, filter, validate } = {}) {
    npmlog_1.default.pause();
    const answers = await inquirer_1.default.prompt([
        {
            type: 'list',
            name: 'prompt',
            message,
            choices,
            pageSize: choices.length,
            filter,
            validate,
        },
    ]);
    npmlog_1.default.resume();
    return answers.prompt;
}
exports.promptSelectOne = promptSelectOne;
/**
 * Prompt for input
 * @param {string} message
 * @param {Pick<import("inquirer").Question, 'filter' | 'validate'>} [options]
 * @returns {Promise<string>}
 */
async function promptTextInput(message, { filter, validate } = {}) {
    npmlog_1.default.pause();
    const answers = await inquirer_1.default.prompt([
        {
            type: 'input',
            name: 'input',
            message,
            filter,
            validate,
        },
    ]);
    npmlog_1.default.resume();
    return answers.input;
}
exports.promptTextInput = promptTextInput;
//# sourceMappingURL=prompt.js.map