import { ListChoiceOptions, Question } from 'inquirer';
/**
 * Prompt for confirmation
 * @param {string} message
 * @returns {Promise<boolean>}
 */
export declare function promptConfirmation(message: string): Promise<boolean>;
/**
 * Prompt for selection
 * @param {string} message
 * @param {{ choices: import("inquirer").ListChoiceOptions[] } & Pick<import("inquirer").Question, 'filter' | 'validate'>} [options]
 * @returns {Promise<string>}
 */
export declare function promptSelectOne(message: string, { choices, filter, validate }?: {
    choices: ListChoiceOptions[];
} & Pick<Question<import("inquirer").Answers>, "filter" | "validate">): Promise<string>;
/**
 * Prompt for input
 * @param {string} message
 * @param {Pick<import("inquirer").Question, 'filter' | 'validate'>} [options]
 * @returns {Promise<string>}
 */
export declare function promptTextInput(message: string, { filter, validate }?: Pick<Question<import("inquirer").Answers>, "filter" | "validate">): Promise<string>;
