import { Package } from '../package';
import { ProjectConfig, RawManifest } from '../models';
/**
 * A representation of the entire project managed by Lerna.
 *
 * Wherever the lerna.json file is located, that is the project root.
 * All package globs are rooted from this location.
 */
export declare class Project {
    config: ProjectConfig;
    configNotFound: boolean;
    rootConfigLocation: string;
    rootPath: string;
    static PACKAGE_GLOB: string;
    static LICENSE_GLOB: string;
    /**
     * @param {string} [cwd] Defaults to process.cwd()
     */
    constructor(cwd?: string);
    /**
     * @param {string} [cwd] Defaults to process.cwd()
     */
    static getPackages(cwd: string): Promise<Package[]>;
    /**
     * @param {string} [cwd] Defaults to process.cwd()
     */
    static getPackagesSync(cwd: string): string[];
    get version(): string;
    set version(val: string);
    get packageConfigs(): string[];
    get packageParentDirs(): string[];
    get manifest(): RawManifest;
    get licensePath(): string;
    get fileFinder(): (fileName: string, fileMapper: any, customGlobOpts?: any) => Promise<any>;
    /**
     * @returns {Promise<Package[]>} A promise resolving to a list of Package instances
     */
    getPackages(): Promise<Package[]>;
    /**
     * @returns {Package[]} A list of Package instances
     */
    getPackagesSync(): string[];
    getPackageLicensePaths(): Promise<string[]>;
    isIndependent(): boolean;
    serializeConfig(): Promise<string>;
}
