"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.applyExtends = void 0;
const tslib_1 = require("tslib");
const fs_extra_1 = tslib_1.__importDefault(require("fs-extra"));
const path_1 = tslib_1.__importDefault(require("path"));
const resolve_from_1 = tslib_1.__importDefault(require("resolve-from"));
const shallow_extend_1 = require("./shallow-extend");
const validation_error_1 = require("../../validation-error");
/**
 * @param {{ [key: string]: unknown }} config
 * @param {string} cwd
 * @param {Set<string>} seen
 */
function applyExtends(config, cwd, seen = new Set()) {
    let defaultConfig = {};
    if ('extends' in config) {
        let pathToDefault;
        try {
            pathToDefault = (0, resolve_from_1.default)(cwd, config.extends);
        }
        catch (err) {
            throw new validation_error_1.ValidationError('ERESOLVED', 'Config .extends must be locally-resolvable', err);
        }
        if (seen.has(pathToDefault)) {
            throw new validation_error_1.ValidationError('ECIRCULAR', 'Config .extends cannot be circular', seen);
        }
        seen.add(pathToDefault);
        defaultConfig = fs_extra_1.default.readJsonSync(pathToDefault, { throws: false });
        delete config.extends; // eslint-disable-line no-param-reassign
        // deprecateConfig(defaultConfig, pathToDefault);
        defaultConfig = applyExtends(defaultConfig, path_1.default.dirname(pathToDefault), seen);
    }
    return (0, shallow_extend_1.shallowExtend)(config, defaultConfig);
}
exports.applyExtends = applyExtends;
//# sourceMappingURL=apply-extends.js.map