"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.reportCycles = void 0;
const tslib_1 = require("tslib");
const npmlog_1 = tslib_1.__importDefault(require("npmlog"));
const validation_error_1 = require("../../validation-error");
function reportCycles(paths, rejectCycles) {
    if (!paths.length) {
        return;
    }
    const cycleMessage = ['Dependency cycles detected, you should fix these!'].concat(paths).join('\n');
    if (rejectCycles) {
        throw new validation_error_1.ValidationError('ECYCLE', cycleMessage);
    }
    npmlog_1.default.warn('ECYCLE', cycleMessage);
}
exports.reportCycles = reportCycles;
//# sourceMappingURL=report-cycles.js.map