"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.PackageGraphNode = void 0;
const tslib_1 = require("tslib");
const semver_1 = tslib_1.__importDefault(require("semver"));
const prerelease_id_from_version_1 = require("../../utils/prerelease-id-from-version");
const PKG = Symbol('pkg');
/**
 * A node in a PackageGraph.
 */
class PackageGraphNode {
    /**
     * @param {import("@lerna/package").Package} pkg
     */
    constructor(pkg) {
        var _a;
        this.name = (_a = pkg === null || pkg === void 0 ? void 0 : pkg.name) !== null && _a !== void 0 ? _a : '';
        this[PKG] = pkg;
        // omit raw pkg from default util.inspect() output
        Object.defineProperty(this, PKG, { enumerable: false });
        this.externalDependencies = new Map();
        this.localDependencies = new Map();
        this.localDependents = new Map();
    }
    get location() {
        return this[PKG].location;
    }
    get pkg() {
        return this[PKG];
    }
    get prereleaseId() {
        return (0, prerelease_id_from_version_1.prereleaseIdFromVersion)(this.version);
    }
    get version() {
        return this[PKG].version;
    }
    /**
     * Determine if the Node satisfies a resolved semver range.
     * @see https://github.com/npm/npm-package-arg#result-object
     *
     * @param {!Result} resolved npm-package-arg Result object
     * @returns {Boolean}
     */
    satisfies({ gitCommittish, gitRange, fetchSpec }) {
        return semver_1.default.satisfies(this.version, (gitCommittish || gitRange || fetchSpec));
    }
    /**
     * Returns a string representation of this node (its name)
     *
     * @returns {String}
     */
    toString() {
        return this.name;
    }
}
exports.PackageGraphNode = PackageGraphNode;
//# sourceMappingURL=package-graph-node.js.map