import { Result } from 'npm-package-arg';
import { Package } from '../../package';
/**
 * A node in a PackageGraph.
 */
export declare class PackageGraphNode {
    name: string;
    externalDependencies: Map<string, any>;
    localDependencies: Map<string, any>;
    localDependents: Map<string, any>;
    /**
     * @param {import("@lerna/package").Package} pkg
     */
    constructor(pkg: Package);
    get location(): string;
    get pkg(): Package;
    get prereleaseId(): string | undefined;
    get version(): string;
    /**
     * Determine if the Node satisfies a resolved semver range.
     * @see https://github.com/npm/npm-package-arg#result-object
     *
     * @param {!Result} resolved npm-package-arg Result object
     * @returns {Boolean}
     */
    satisfies({ gitCommittish, gitRange, fetchSpec }: Partial<Result>): boolean;
    /**
     * Returns a string representation of this node (its name)
     *
     * @returns {String}
     */
    toString(): string;
}
