import { Logger } from 'npmlog';
import { Project } from './project/project';
import { ChangedCommandOption, CommandType, DiffCommandOption, ExecCommandOption, ExecOpts, InitCommandOption, ListCommandOption, ProjectConfig, PublishCommandOption, VersionCommandOption, WatchCommandOption } from './models';
import { PackageGraph } from './package-graph/package-graph';
type AvailableCommandOption = ChangedCommandOption | DiffCommandOption | ExecCommandOption | InitCommandOption | ListCommandOption | PublishCommandOption | VersionCommandOption | WatchCommandOption | ProjectConfig;
export declare class Command<T extends AvailableCommandOption> {
    argv: any;
    concurrency: number;
    envDefaults: any;
    sort: any;
    toposort?: boolean;
    execOpts: ExecOpts;
    commandName: CommandType;
    composed: any;
    logger: Logger;
    options: T & ExecOpts & ProjectConfig;
    project: Project;
    packageGraph: PackageGraph;
    runner?: Promise<any>;
    constructor(_argv: AvailableCommandOption);
    then(onResolved: typeof Promise.resolve, onRejected: typeof Promise.reject): Promise<unknown> | undefined;
    catch(onRejected: typeof Promise.reject): Promise<any> | undefined;
    get requiresGit(): boolean;
    get otherCommandConfigs(): string[];
    configureEnvironment(): void;
    configureOptions(): void;
    configureProperties(): void;
    configureLogging(): void;
    enableProgressBar(): void;
    gitInitialized(): boolean;
    runValidations(): void;
    runPreparations(): Promise<any> | void;
    runCommand(): Promise<any>;
    initialize(): any | Promise<any>;
    execute(): any | Promise<any>;
}
export {};
