import execa from 'execa';
import { Package } from './package';
/**
 * Execute a command asynchronously, piping stdio by default.
 * @param {string} command
 * @param {string[]} args
 * @param {import("execa").Options} [opts]
 */
export declare function exec(command: string, args: string[], opts?: execa.Options & {
    pkg?: Package;
}, dryRun?: boolean): Promise<any>;
/**
 * Execute a command synchronously.
 * @param {string} command
 * @param {string[]} args
 * @param {import("execa").SyncOptions} [opts]
 */
export declare function execSync(command: string, args?: string[], opts?: execa.SyncOptions<string>, dryRun?: boolean): string;
/**
 * Spawn a command asynchronously, _always_ inheriting stdio.
 * @param {string} command
 * @param {string[]} args
 * @param {import("execa").Options} [opts]
 */
export declare function spawn(command: string, args: string[], opts?: execa.Options & {
    pkg?: Package;
}, dryRun?: boolean): Promise<any>;
/**
 * Spawn a command asynchronously, streaming stdio with optional prefix.
 * @param {string} command
 * @param {string[]} args
 * @param {import("execa").Options} [opts]
 * @param {string} [prefix]
 */
export declare function spawnStreaming(command: string, args: string[], opts?: execa.Options & {
    pkg?: Package;
}, prefix?: string | boolean, dryRun?: boolean): Promise<any>;
export declare function getChildProcessCount(): number;
export declare function getExitCode(result: any): any;
/**
 * @param {string} command
 * @param {string[]} args
 * @param {import("execa").Options} opts
 */
export declare function spawnProcess(command: string, args: string[], opts: execa.Options & {
    pkg?: Package;
}, dryRun?: boolean): any;
/**
 * Spawn a command asynchronously, _always_ inheriting stdio.
 * @param {string} command
 * @param {string[]} args
 * @param {import("execa").Options} [opts]
 */
export declare function wrapError(spawned: execa.ExecaChildProcess & {
    pkg?: Package;
}): Promise<execa.ExecaReturnValue<string>>;
/**
 * Log the child-process command and its arguments as dry-run (without executing the process)
 * @param {string} command
 * @param {string[]} args
 */
export declare function logExecCommand(command: string, args?: string[]): string;
