"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.lerna = void 0;
const tslib_1 = require("tslib");
const load_json_file_1 = tslib_1.__importDefault(require("load-json-file"));
const path_1 = tslib_1.__importDefault(require("path"));
const cli_changed_commands_1 = tslib_1.__importDefault(require("./cli-commands/cli-changed-commands"));
const cli_diff_commands_1 = tslib_1.__importDefault(require("./cli-commands/cli-diff-commands"));
const cli_exec_commands_1 = tslib_1.__importDefault(require("./cli-commands/cli-exec-commands"));
const cli_init_commands_1 = tslib_1.__importDefault(require("./cli-commands/cli-init-commands"));
const cli_list_commands_1 = tslib_1.__importDefault(require("./cli-commands/cli-list-commands"));
const cli_publish_commands_1 = tslib_1.__importDefault(require("./cli-commands/cli-publish-commands"));
const cli_run_commands_1 = tslib_1.__importDefault(require("./cli-commands/cli-run-commands"));
const cli_version_commands_1 = tslib_1.__importDefault(require("./cli-commands/cli-version-commands"));
const cli_watch_commands_1 = tslib_1.__importDefault(require("./cli-commands/cli-watch-commands"));
const lerna_cli_1 = tslib_1.__importDefault(require("./lerna-cli"));
function lerna(argv) {
    var _a;
    const cliPkg = load_json_file_1.default.sync(path_1.default.join(__dirname, '../', 'package.json'));
    const context = {
        lernaVersion: ((_a = cliPkg === null || cliPkg === void 0 ? void 0 : cliPkg.version) !== null && _a !== void 0 ? _a : ''),
    };
    return (0, lerna_cli_1.default)()
        .command(cli_changed_commands_1.default)
        .command(cli_diff_commands_1.default)
        .command(cli_exec_commands_1.default)
        .command(cli_init_commands_1.default)
        .command(cli_list_commands_1.default)
        .command(cli_publish_commands_1.default)
        .command(cli_run_commands_1.default)
        .command(cli_version_commands_1.default)
        .command(cli_watch_commands_1.default)
        .parse(argv, context);
}
exports.lerna = lerna;
//# sourceMappingURL=lerna-entry.js.map