"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
const tslib_1 = require("tslib");
const dedent_1 = tslib_1.__importDefault(require("dedent"));
const npmlog_1 = tslib_1.__importDefault(require("npmlog"));
const yargs_1 = tslib_1.__importDefault(require("yargs/yargs"));
const global_options_1 = require("./global-options");
/**
 * A factory that returns a yargs() instance configured with everything except commands.
 * Chain .parse() from this method to invoke.
 *
 * @param {Array = []} argv
 * @param {String = process.cwd()} cwd
 */
function lernaCLI(argv, cwd) {
    const cli = (0, yargs_1.default)(argv, cwd);
    return (0, global_options_1.globalOptions)(cli)
        .usage('Usage: $0 <command> [options]')
        .demandCommand(1, 'A command is required. Pass --help to see all available commands and options.')
        .recommendCommands()
        .strict()
        .fail((msg, err) => {
        // certain yargs validations throw strings :P
        const actual = err || new Error(msg);
        // ValidationErrors are already logged, as are package errors
        if (actual.name !== 'ValidationError' && !actual.pkg) {
            // the recommendCommands() message is too terse
            if (/Did you mean/.test(actual.message)) {
                npmlog_1.default.error('lerna-lite', `Unknown command "${cli.parsed.argv._[0]}"`);
            }
            npmlog_1.default.error('lerna-lite', actual.message);
        }
        // exit non-zero so the CLI can be usefully chained
        cli.exit(actual.exitCode > 0 ? actual.exitCode : 1, actual);
    })
        .alias('h', 'help')
        .alias('v', 'version')
        .wrap(cli.terminalWidth()).epilogue((0, dedent_1.default) `
      When a command fails, all logs are written to lerna-debug.log in the current working directory.

      For more information, find our manual at https://github.com/lerna/lerna
    `);
}
exports.default = lernaCLI;
//# sourceMappingURL=lerna-cli.js.map