"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
const tslib_1 = require("tslib");
const npmlog_1 = tslib_1.__importDefault(require("npmlog"));
const publish_1 = require("@lerna-lite/publish");
const cli_version_commands_1 = tslib_1.__importStar(require("./cli-version-commands"));
/**
 * @see https://github.com/yargs/yargs/blob/master/docs/advanced.md#providing-a-command-module
 */
function composeVersionOptions(yargs) {
    (0, cli_version_commands_1.addBumpPositional)(yargs, ['from-git', 'from-package']);
    cli_version_commands_1.default.builder(yargs, 'publish');
    return yargs;
}
exports.default = {
    command: 'publish [bump]',
    describe: 'Publish packages in the current project.',
    builder: (yargs) => {
        const opts = {
            c: {
                describe: 'Publish packages after every successful merge using the sha as part of the tag.',
                alias: 'canary',
                type: 'boolean',
            },
            // preid is copied from ../version/command because a whitelist for one option isn't worth it
            preid: {
                describe: 'Specify the prerelease identifier when publishing a prerelease',
                type: 'string',
                requiresArg: true,
                defaultDescription: 'alpha',
            },
            'cleanup-temp-files': {
                describe: 'Cleanup packed temp files/folders after publish process is finished, defaults to false.',
                type: 'boolean',
            },
            contents: {
                describe: 'Subdirectory to publish. Must apply to ALL packages.',
                type: 'string',
                requiresArg: true,
                defaultDescription: '.',
            },
            'dist-tag': {
                describe: 'Publish packages with the specified npm dist-tag',
                type: 'string',
                requiresArg: true,
            },
            'legacy-auth': {
                describe: 'Legacy Base64 Encoded username and password.',
                type: 'string',
            },
            'pre-dist-tag': {
                describe: 'Publish prerelease packages with the specified npm dist-tag',
                type: 'string',
                requiresArg: true,
            },
            'git-head': {
                describe: 'Explicit SHA to set as gitHead when packing tarballs, only allowed with "from-package" positional.',
                type: 'string',
                requiresArg: true,
            },
            'graph-type': {
                describe: 'Type of dependency to use when determining package hierarchy.',
                choices: ['all', 'dependencies'],
                defaultDescription: 'dependencies',
            },
            'ignore-prepublish': {
                describe: 'Disable deprecated "prepublish" lifecycle script',
                type: 'boolean',
            },
            'ignore-scripts': {
                describe: 'Disable all lifecycle scripts',
                type: 'boolean',
            },
            // TODO: (major) make --no-granular-pathspec the default
            'no-granular-pathspec': {
                describe: 'Do not reset changes file-by-file, but globally.',
                type: 'boolean',
            },
            'granular-pathspec': {
                // proxy for --no-granular-pathspec
                hidden: true,
                // describe: 'Reset changes file-by-file, not globally.',
                type: 'boolean',
            },
            otp: {
                describe: 'Supply a one-time password for publishing with two-factor authentication.',
                type: 'string',
                requiresArg: true,
            },
            'no-publish-config-overrides': {
                // proxy for --publish-config-overrides
                hidden: true,
                type: 'boolean',
            },
            'publish-config-overrides': {
                describe: 'apply publishConfig overrides.',
                type: 'boolean',
            },
            registry: {
                describe: 'Use the specified registry for all npm client operations.',
                type: 'string',
                requiresArg: true,
            },
            'remove-package-fields': {
                describe: 'Remove fields from each package.json before publishing them to the registry, removing fields from a complex object is also supported via the dot notation (ie "scripts.build").',
                type: 'array',
            },
            'require-scripts': {
                describe: 'Execute ./scripts/prepublish.js and ./scripts/postpublish.js, relative to package root.',
                type: 'boolean',
            },
            'no-git-reset': {
                describe: 'Do not reset changes to working tree after publishing is complete.',
                type: 'boolean',
            },
            'git-reset': {
                // proxy for --no-git-reset
                hidden: true,
                type: 'boolean',
            },
            'temp-tag': {
                describe: 'Create a temporary tag while publishing.',
                type: 'boolean',
            },
            'no-verify-access': {
                // proxy for --verify-access
                describe: 'Do not verify package read-write access for current npm user.',
                type: 'boolean',
            },
            'summary-file': {
                // generate lerna publish json output.
                describe: 'Generate a json summary report after all packages have been successfully published, you can pass an optional path for where to save the file.',
                type: 'string',
            },
            'verify-access': {
                describe: 'Verify package read-write access for current npm user.',
                type: 'boolean',
            },
            'workspace-strict-match': {
                describe: 'Strict match transform version numbers to an exact range (like "1.2.3") rather than with a caret (like ^1.2.3) when using `workspace:*`.',
                type: 'boolean',
            },
        };
        composeVersionOptions(yargs);
        yargs.options(opts);
        // 'unhide' duplicate options
        const { hiddenOptions } = yargs.getOptions();
        const sharedKeys = ['preid', 'y', 'ignore-scripts'];
        for (const sharedKey of sharedKeys) {
            hiddenOptions.splice(hiddenOptions.findIndex((k) => k === sharedKey), 1);
        }
        yargs.group(Object.keys(opts).concat(sharedKeys), 'Command Options:');
        return yargs
            .option('npm-tag', {
            // TODO: remove in next major release
            hidden: true,
            conflicts: 'dist-tag',
            type: 'string',
            requiresArg: true,
        })
            .option('verify-registry', {
            // TODO: remove in next major release
            hidden: true,
            type: 'boolean',
        })
            .option('skip-npm', {
            // TODO: remove in next major release
            // deprecation notice handled in initialize()
            hidden: true,
            type: 'boolean',
        })
            .check((argv) => {
            /* eslint-disable no-param-reassign */
            if (argv.npmTag) {
                argv.distTag = argv.npmTag;
                argv['dist-tag'] = argv.npmTag;
                delete argv.npmTag;
                delete argv['npm-tag'];
                npmlog_1.default.warn('deprecated', '--npm-tag has been renamed --dist-tag');
            }
            if (argv.requireScripts) {
                npmlog_1.default.warn('deprecated', '--require-scripts has been deprecated and will be removed in next major');
            }
            /* eslint-enable no-param-reassign */
            return argv;
        });
    },
    handler: (argv) => {
        return new publish_1.PublishCommand(argv);
    },
};
//# sourceMappingURL=cli-publish-commands.js.map