"use strict";
var __createBinding = (this && this.__createBinding) || (Object.create ? (function(o, m, k, k2) {
    if (k2 === undefined) k2 = k;
    var desc = Object.getOwnPropertyDescriptor(m, k);
    if (!desc || ("get" in desc ? !m.__esModule : desc.writable || desc.configurable)) {
      desc = { enumerable: true, get: function() { return m[k]; } };
    }
    Object.defineProperty(o, k2, desc);
}) : (function(o, m, k, k2) {
    if (k2 === undefined) k2 = k;
    o[k2] = m[k];
}));
var __setModuleDefault = (this && this.__setModuleDefault) || (Object.create ? (function(o, v) {
    Object.defineProperty(o, "default", { enumerable: true, value: v });
}) : function(o, v) {
    o["default"] = v;
});
var __importStar = (this && this.__importStar) || function (mod) {
    if (mod && mod.__esModule) return mod;
    var result = {};
    if (mod != null) for (var k in mod) if (k !== "default" && Object.prototype.hasOwnProperty.call(mod, k)) __createBinding(result, mod, k);
    __setModuleDefault(result, mod);
    return result;
};
Object.defineProperty(exports, "__esModule", { value: true });
const listable_1 = require("@lerna-lite/listable");
const filter_options_1 = require("../filter-options");
/**
 * @see https://github.com/yargs/yargs/blob/master/docs/advanced.md#providing-a-command-module
 */
exports.default = {
    command: 'list',
    aliases: ['ls', 'la', 'll'],
    describe: 'List local packages',
    builder: (yargs) => {
        listable_1.listable.options(yargs);
        return (0, filter_options_1.filterOptions)(yargs);
    },
    handler: async (argv) => {
        try {
            // @ts-ignore
            // eslint-disable-next-line import/no-unresolved
            const { ListCommand } = await Promise.resolve().then(() => __importStar(require('@lerna-lite/list')));
            new ListCommand(argv);
        }
        catch (err) {
            console.error(`"@lerna-lite/list" is optional and was not found. Please install it with "npm install @lerna-lite/list -D -W".`, err);
        }
    },
};
//# sourceMappingURL=cli-list-commands.js.map