"use strict";
var __createBinding = (this && this.__createBinding) || (Object.create ? (function(o, m, k, k2) {
    if (k2 === undefined) k2 = k;
    var desc = Object.getOwnPropertyDescriptor(m, k);
    if (!desc || ("get" in desc ? !m.__esModule : desc.writable || desc.configurable)) {
      desc = { enumerable: true, get: function() { return m[k]; } };
    }
    Object.defineProperty(o, k2, desc);
}) : (function(o, m, k, k2) {
    if (k2 === undefined) k2 = k;
    o[k2] = m[k];
}));
var __setModuleDefault = (this && this.__setModuleDefault) || (Object.create ? (function(o, v) {
    Object.defineProperty(o, "default", { enumerable: true, value: v });
}) : function(o, v) {
    o["default"] = v;
});
var __importStar = (this && this.__importStar) || function (mod) {
    if (mod && mod.__esModule) return mod;
    var result = {};
    if (mod != null) for (var k in mod) if (k !== "default" && Object.prototype.hasOwnProperty.call(mod, k)) __createBinding(result, mod, k);
    __setModuleDefault(result, mod);
    return result;
};
Object.defineProperty(exports, "__esModule", { value: true });
const listable_1 = require("@lerna-lite/listable");
/**
 * @see https://github.com/yargs/yargs/blob/master/docs/advanced.md#providing-a-command-module
 */
exports.default = {
    command: 'changed',
    aliases: ['updated'],
    describe: 'List local packages that have changed since the last tagged release',
    builder: (yargs) => {
        const opts = {
            // only the relevant bits from `lerna version`
            'conventional-commits': {
                // fallback for overzealous --conventional-graduate
                hidden: true,
                type: 'boolean',
            },
            'conventional-graduate': {
                describe: 'Detect currently prereleased packages that would change to a non-prerelease version.',
                // type must remain ambiguous because it is overloaded (boolean _or_ string _or_ array)
            },
            'force-publish': {
                describe: 'Always include targeted packages when detecting changed packages, skipping default logic.',
                // type must remain ambiguous because it is overloaded (boolean _or_ string _or_ array)
            },
            'ignore-changes': {
                describe: [
                    'Ignore changes in files matched by glob(s) when detecting changed packages.',
                    'Pass --no-ignore-changes to completely disable.',
                ].join('\n'),
                type: 'array',
            },
            'include-merged-tags': {
                describe: 'Include tags from merged branches when detecting changed packages.',
                type: 'boolean',
            },
        };
        yargs.options(opts).group(Object.keys(opts), 'Command Options:');
        return listable_1.listable.options(yargs, 'Output Options:');
    },
    handler: async (argv) => {
        try {
            // @ts-ignore
            // eslint-disable-next-line import/no-unresolved
            const { ChangedCommand } = await Promise.resolve().then(() => __importStar(require('@lerna-lite/changed')));
            new ChangedCommand(argv);
        }
        catch (err) {
            console.error(`"@lerna-lite/changed" is optional and was not found. Please install it with "npm install @lerna-lite/changed -D -W".`, err);
        }
    },
};
//# sourceMappingURL=cli-changed-commands.js.map