"use client";
import {
  useTouchDevice
} from "../__chunks/FPWVE2AH.js";
import {
  TagRemoveIdContext,
  TagValueContext,
  useTagContext
} from "../__chunks/VJQU3YUE.js";
import {
  useCompositeItem
} from "../__chunks/SBSPVDDI.js";
import "../__chunks/5VQZOHHZ.js";
import "../__chunks/Y62RTBST.js";
import "../__chunks/APTFW6PT.js";
import "../__chunks/2W3RN7C5.js";
import "../__chunks/OE2EFRVA.js";
import "../__chunks/SWN3JYXT.js";
import "../__chunks/RTNCFSKZ.js";
import "../__chunks/5CPL3B7G.js";
import {
  createElement,
  createHook,
  forwardRef,
  memo
} from "../__chunks/VOQWLFSQ.js";
import {
  useBooleanEvent,
  useEvent,
  useId,
  useWrapElement
} from "../__chunks/5GGHRIN3.js";
import "../__chunks/SK3NAZA3.js";
import {
  __objRest,
  __spreadProps,
  __spreadValues
} from "../__chunks/3YLGPPWQ.js";

// src/tag/tag.tsx
import { invariant } from "@ariakit/core/utils/misc";
import { isApple } from "@ariakit/core/utils/platform";
import { useCallback, useState } from "react";
import { jsx } from "react/jsx-runtime";
var TagName = "div";
var useTag = createHook(function useTag2(_a) {
  var _b = _a, {
    store,
    value,
    getItem: getItemProp,
    removeOnKeyPress = true
  } = _b, props = __objRest(_b, [
    "store",
    "value",
    "getItem",
    "removeOnKeyPress"
  ]);
  const context = useTagContext();
  store = store || context;
  invariant(
    store,
    process.env.NODE_ENV !== "production" && "Tag must be wrapped in a TagList component."
  );
  const id = useId(props.id);
  const touchDevice = useTouchDevice();
  const getItem = useCallback(
    (item) => {
      const nextItem = __spreadProps(__spreadValues({}, item), { value });
      if (getItemProp) {
        return getItemProp(nextItem);
      }
      return nextItem;
    },
    [value, getItemProp]
  );
  const onKeyDownProp = props.onKeyDown;
  const removeOnKeyPressProp = useBooleanEvent(removeOnKeyPress);
  const onKeyDown = useEvent((event) => {
    onKeyDownProp == null ? void 0 : onKeyDownProp(event);
    if (event.defaultPrevented) return;
    const { inputElement } = store.getState();
    const isBackspace = event.key === "Backspace";
    const isRemoveKey = isBackspace || event.key === "Delete";
    if (isRemoveKey && removeOnKeyPressProp(event)) {
      event.preventDefault();
      store.removeValue(value);
      const nextId = isBackspace ? store.previous() || store.next() : store.next();
      store.move(nextId);
    }
    const isPrintableKey = !event.ctrlKey && !event.metaKey && event.key.length === 1;
    const pc = !isApple();
    const v = event.key === "v" || event.key === "V";
    const mod = pc ? event.ctrlKey : event.metaKey;
    const isPaste = mod && v;
    if (isPrintableKey || isPaste) {
      inputElement == null ? void 0 : inputElement.focus();
    }
  });
  const [removeId, setRemoveId] = useState();
  props = useWrapElement(
    props,
    (element) => /* @__PURE__ */ jsx(TagValueContext.Provider, { value, children: /* @__PURE__ */ jsx(TagRemoveIdContext.Provider, { value: setRemoveId, children: element }) }),
    [value]
  );
  props = __spreadProps(__spreadValues({
    id,
    role: !touchDevice ? "option" : "listitem",
    children: value,
    "aria-describedby": removeId
  }, props), {
    onKeyDown
  });
  props = useCompositeItem(__spreadProps(__spreadValues({
    store
  }, props), {
    getItem
  }));
  return props;
});
var Tag = memo(
  forwardRef(function Tag2(props) {
    const htmlProps = useTag(props);
    return createElement(TagName, htmlProps);
  })
);
export {
  Tag,
  useTag
};
