"use client";
import {
  useTouchDevice
} from "../__chunks/FPWVE2AH.js";
import {
  TagRemoveIdContext,
  TagValueContext,
  useTagContext
} from "../__chunks/VJQU3YUE.js";
import {
  Role
} from "../__chunks/QJ4LGO2N.js";
import "../__chunks/APTFW6PT.js";
import "../__chunks/5CPL3B7G.js";
import {
  createElement,
  createHook,
  forwardRef
} from "../__chunks/VOQWLFSQ.js";
import {
  useBooleanEvent,
  useEvent,
  useId
} from "../__chunks/5GGHRIN3.js";
import "../__chunks/SK3NAZA3.js";
import {
  __objRest,
  __spreadProps,
  __spreadValues
} from "../__chunks/3YLGPPWQ.js";

// src/tag/tag-remove.tsx
import { invariant } from "@ariakit/core/utils/misc";
import { useContext, useEffect } from "react";
import { jsx, jsxs } from "react/jsx-runtime";
var TagName = "button";
var useTagRemove = createHook(
  function useTagRemove2(_a) {
    var _b = _a, {
      store,
      value: valueProp,
      removeOnClick = true
    } = _b, props = __objRest(_b, [
      "store",
      "value",
      "removeOnClick"
    ]);
    const context = useTagContext();
    store = store || context;
    invariant(
      store,
      process.env.NODE_ENV !== "production" && "TagRemove must receive a `store` prop or be wrapped in a TagProvider component."
    );
    const id = useId(props.id);
    const setRemoveId = useContext(TagRemoveIdContext);
    const valueFromContext = useContext(TagValueContext);
    const withinTag = valueFromContext !== null;
    const value = valueProp != null ? valueProp : valueFromContext;
    useEffect(() => {
      setRemoveId == null ? void 0 : setRemoveId(id);
      return () => setRemoveId == null ? void 0 : setRemoveId();
    }, [id, setRemoveId]);
    const onClickProp = props.onClick;
    const removeOnClickProp = useBooleanEvent(removeOnClick);
    const onClick = useEvent((event) => {
      onClickProp == null ? void 0 : onClickProp(event);
      if (event.defaultPrevented) return;
      if (!store) return;
      if (!value) return;
      if (!removeOnClickProp(event)) return;
      const { inputElement } = store.getState();
      store.removeValue(value);
      inputElement == null ? void 0 : inputElement.focus();
    });
    const children = /* @__PURE__ */ jsxs(
      "svg",
      {
        display: "block",
        viewBox: "0 0 24 24",
        fill: "none",
        stroke: "currentColor",
        strokeWidth: 1.5,
        strokeLinecap: "round",
        strokeLinejoin: "round",
        height: "1em",
        width: "1em",
        "aria-hidden": true,
        children: [
          /* @__PURE__ */ jsx("path", { d: "M7.28782 5.46243C7.80963 4.92308 8.07054 4.65341 8.37751 4.46038C8.64963 4.28926 8.94749 4.16299 9.25969 4.0864C9.61186 4 9.98709 4 10.7375 4H16.8C17.9201 4 18.4802 4 18.908 4.21799C19.2843 4.40973 19.5903 4.71569 19.782 5.09202C20 5.51984 20 6.0799 20 7.2V16.8C20 17.9201 20 18.4802 19.782 18.908C19.5903 19.2843 19.2843 19.5903 18.908 19.782C18.4802 20 17.9201 20 16.8 20H10.7512C9.99584 20 9.61818 20 9.264 19.9126C8.95004 19.8351 8.65067 19.7073 8.37748 19.5342C8.06931 19.339 7.80802 19.0663 7.28544 18.521L2.59879 13.63C2.03714 13.0439 1.75631 12.7508 1.65115 12.4158C1.55859 12.121 1.55935 11.8048 1.65332 11.5104C1.7601 11.1759 2.04233 10.8842 2.60679 10.3008L7.28782 5.46243Z" }),
          /* @__PURE__ */ jsx("path", { d: "M10.052 9L16 15M15.948 9L10 15" })
        ]
      }
    );
    const touchDevice = useTouchDevice() && withinTag;
    props = __spreadProps(__spreadValues({
      id,
      children,
      role: touchDevice ? "button" : void 0,
      "aria-hidden": !touchDevice,
      "aria-label": touchDevice ? `Remove ${value}` : withinTag ? "Press Delete or Backspace to remove" : void 0
    }, props), {
      onClick,
      render: withinTag ? /* @__PURE__ */ jsx(Role.span, { render: props.render }) : props.render
    });
    return props;
  }
);
var TagRemove = forwardRef(function TagRemove2(props) {
  const htmlProps = useTagRemove(props);
  return createElement(TagName, htmlProps);
});
export {
  TagRemove,
  useTagRemove
};
