"use client";
import {
  useTouchDevice
} from "../__chunks/FPWVE2AH.js";
import {
  TagScopedContextProvider,
  useTagProviderContext
} from "../__chunks/VJQU3YUE.js";
import {
  useComposite
} from "../__chunks/NSTBQJLB.js";
import "../__chunks/5VQZOHHZ.js";
import "../__chunks/APTFW6PT.js";
import "../__chunks/OE2EFRVA.js";
import "../__chunks/SWN3JYXT.js";
import "../__chunks/5CPL3B7G.js";
import {
  createElement,
  createHook,
  forwardRef
} from "../__chunks/VOQWLFSQ.js";
import {
  useEvent,
  useWrapElement
} from "../__chunks/5GGHRIN3.js";
import "../__chunks/SK3NAZA3.js";
import {
  __objRest,
  __spreadProps,
  __spreadValues
} from "../__chunks/3YLGPPWQ.js";

// src/tag/tag-list.tsx
import { queueBeforeEvent } from "@ariakit/core/utils/events";
import { getClosestFocusable } from "@ariakit/core/utils/focus";
import { invariant } from "@ariakit/core/utils/misc";
import { isApple } from "@ariakit/core/utils/platform";
import { UndoManager } from "@ariakit/core/utils/undo";
import { Fragment, jsx, jsxs } from "react/jsx-runtime";
var TagName = "div";
var useTagList = createHook(
  function useTagList2(_a) {
    var _b = _a, { store } = _b, props = __objRest(_b, ["store"]);
    const context = useTagProviderContext();
    store = store || context;
    invariant(
      store,
      process.env.NODE_ENV !== "production" && "TagList must receive a `store` prop or be wrapped in a TagProvider component."
    );
    const onMouseDownProp = props.onMouseDown;
    const onMouseDown = useEvent((event) => {
      onMouseDownProp == null ? void 0 : onMouseDownProp(event);
      if (event.defaultPrevented) return;
      const target = event.target;
      const currentTarget = event.currentTarget;
      const focusableTarget = getClosestFocusable(target);
      const isSelfFocusable = focusableTarget === currentTarget;
      if (!isSelfFocusable && currentTarget.contains(focusableTarget)) return;
      const { inputElement } = store.getState();
      queueBeforeEvent(event.currentTarget, "mouseup", () => {
        inputElement == null ? void 0 : inputElement.focus();
      });
    });
    const onKeyDownProp = props.onKeyDown;
    const onKeyDown = useEvent((event) => {
      onKeyDownProp == null ? void 0 : onKeyDownProp(event);
      if (event.defaultPrevented) return;
      const pc = !isApple();
      const z = event.key === "z" || event.key === "Z";
      const mod = pc ? event.ctrlKey : event.metaKey;
      const shiftZ = event.shiftKey && z || pc && event.key === "y";
      if (mod && shiftZ) {
        event.preventDefault();
        UndoManager.redo();
      } else if (mod && z) {
        event.preventDefault();
        UndoManager.undo();
      }
    });
    props = useWrapElement(
      props,
      (element) => /* @__PURE__ */ jsx(TagScopedContextProvider, { value: store, children: element }),
      [store]
    );
    props = __spreadProps(__spreadValues({}, props), {
      onMouseDown,
      onKeyDown
    });
    props = useComposite(__spreadValues({ store }, props));
    const orientation = store.useState(
      (state) => state.orientation === "both" ? void 0 : state.orientation
    );
    const items = store.useState((state) => state.renderedItems);
    const itemIds = items.filter((item) => !!item.value).map((item) => item.id);
    const labelId = store.useState((state) => {
      var _a2;
      return (_a2 = state.labelElement) == null ? void 0 : _a2.id;
    });
    const listboxProps = {};
    for (const key in props) {
      if (key === "role" || key.startsWith("aria-")) {
        const prop = key;
        listboxProps[prop] = props[prop];
        delete props[prop];
      }
    }
    const touchDevice = useTouchDevice();
    const children = /* @__PURE__ */ jsxs(Fragment, { children: [
      /* @__PURE__ */ jsx(
        "div",
        __spreadProps(__spreadValues({
          role: touchDevice ? "list" : "listbox",
          "aria-live": "polite",
          "aria-relevant": "all",
          "aria-atomic": true,
          "aria-labelledby": labelId,
          "aria-orientation": orientation,
          "aria-owns": itemIds.join(" ")
        }, listboxProps), {
          style: { position: "fixed" }
        })
      ),
      props.children
    ] });
    props = __spreadProps(__spreadValues({}, props), {
      children
    });
    return props;
  }
);
var TagList = forwardRef(function TagList2(props) {
  const htmlProps = useTagList(props);
  return createElement(TagName, htmlProps);
});
export {
  TagList,
  useTagList
};
