"use client";
import {
  useTagContext
} from "../__chunks/VJQU3YUE.js";
import "../__chunks/APTFW6PT.js";
import "../__chunks/5CPL3B7G.js";
import {
  createElement,
  createHook,
  forwardRef
} from "../__chunks/VOQWLFSQ.js";
import {
  useId,
  useMergeRefs
} from "../__chunks/5GGHRIN3.js";
import "../__chunks/SK3NAZA3.js";
import {
  __objRest,
  __spreadProps,
  __spreadValues
} from "../__chunks/3YLGPPWQ.js";

// src/tag/tag-list-label.tsx
import { invariant } from "@ariakit/core/utils/misc";
var TagName = "label";
var useTagListLabel = createHook(
  function useTagListLabel2(_a) {
    var _b = _a, { store } = _b, props = __objRest(_b, ["store"]);
    const context = useTagContext();
    store = store || context;
    invariant(
      store,
      process.env.NODE_ENV !== "production" && "TagListLabel must receive a `store` prop or be wrapped in a TagProvider component."
    );
    const id = useId(props.id);
    const htmlFor = store.useState((state) => {
      var _a2;
      return (_a2 = state.inputElement) == null ? void 0 : _a2.id;
    });
    props = __spreadProps(__spreadValues({
      id,
      htmlFor
    }, props), {
      ref: useMergeRefs(store.setLabelElement, props.ref)
    });
    return props;
  }
);
var TagListLabel = forwardRef(function TagListLabel2(props) {
  const htmlProps = useTagListLabel(props);
  return createElement(TagName, htmlProps);
});
export {
  TagListLabel,
  useTagListLabel
};
