"use client";
import {
  useTabScopedContext
} from "../__chunks/QGC5LOGZ.js";
import {
  CompositeItem,
  useCompositeItem
} from "../__chunks/SBSPVDDI.js";
import "../__chunks/5VQZOHHZ.js";
import "../__chunks/Y62RTBST.js";
import "../__chunks/APTFW6PT.js";
import "../__chunks/2W3RN7C5.js";
import "../__chunks/OE2EFRVA.js";
import "../__chunks/SWN3JYXT.js";
import {
  useStoreState
} from "../__chunks/RTNCFSKZ.js";
import "../__chunks/5CPL3B7G.js";
import {
  createElement,
  createHook,
  forwardRef,
  memo
} from "../__chunks/VOQWLFSQ.js";
import {
  useEvent,
  useId
} from "../__chunks/5GGHRIN3.js";
import "../__chunks/SK3NAZA3.js";
import {
  __objRest,
  __spreadProps,
  __spreadValues
} from "../__chunks/3YLGPPWQ.js";

// src/tab/tab.tsx
import { disabledFromProps, invariant } from "@ariakit/core/utils/misc";
import { useCallback } from "react";
import { jsx } from "react/jsx-runtime";
var TagName = "button";
var useTab = createHook(function useTab2(_a) {
  var _b = _a, {
    store,
    getItem: getItemProp
  } = _b, props = __objRest(_b, [
    "store",
    "getItem"
  ]);
  var _a2;
  const context = useTabScopedContext();
  store = store || context;
  invariant(
    store,
    process.env.NODE_ENV !== "production" && "Tab must be wrapped in a TabList component."
  );
  const defaultId = useId();
  const id = props.id || defaultId;
  const dimmed = disabledFromProps(props);
  const getItem = useCallback(
    (item) => {
      const nextItem = __spreadProps(__spreadValues({}, item), { dimmed });
      if (getItemProp) {
        return getItemProp(nextItem);
      }
      return nextItem;
    },
    [dimmed, getItemProp]
  );
  const onClickProp = props.onClick;
  const onClick = useEvent((event) => {
    onClickProp == null ? void 0 : onClickProp(event);
    if (event.defaultPrevented) return;
    store == null ? void 0 : store.setSelectedId(id);
  });
  const panelId = store.panels.useState(
    (state) => {
      var _a3;
      return (_a3 = state.items.find((item) => item.tabId === id)) == null ? void 0 : _a3.id;
    }
  );
  const shouldRegisterItem = defaultId ? props.shouldRegisterItem : false;
  const isActive = store.useState((state) => !!id && state.activeId === id);
  const selected = store.useState((state) => !!id && state.selectedId === id);
  const hasActiveItem = store.useState((state) => !!store.item(state.activeId));
  const canRegisterComposedItem = isActive || selected && !hasActiveItem;
  const accessibleWhenDisabled = selected || ((_a2 = props.accessibleWhenDisabled) != null ? _a2 : true);
  const isWithinVirtualFocusComposite = useStoreState(
    store.combobox || store.composite,
    "virtualFocus"
  );
  if (isWithinVirtualFocusComposite) {
    props = __spreadProps(__spreadValues({}, props), {
      tabIndex: -1
    });
  }
  props = __spreadProps(__spreadValues({
    id,
    role: "tab",
    "aria-selected": selected,
    "aria-controls": panelId || void 0
  }, props), {
    onClick
  });
  if (store.composite) {
    const defaultProps = {
      id,
      accessibleWhenDisabled,
      store: store.composite,
      shouldRegisterItem: canRegisterComposedItem && shouldRegisterItem,
      rowId: props.rowId,
      render: props.render
    };
    props = __spreadProps(__spreadValues({}, props), {
      render: /* @__PURE__ */ jsx(
        CompositeItem,
        __spreadProps(__spreadValues({}, defaultProps), {
          render: store.combobox && store.composite !== store.combobox ? /* @__PURE__ */ jsx(CompositeItem, __spreadProps(__spreadValues({}, defaultProps), { store: store.combobox })) : defaultProps.render
        })
      )
    });
  }
  props = useCompositeItem(__spreadProps(__spreadValues({
    store
  }, props), {
    accessibleWhenDisabled,
    getItem,
    shouldRegisterItem
  }));
  return props;
});
var Tab = memo(
  forwardRef(function Tab2(props) {
    const htmlProps = useTab(props);
    return createElement(TagName, htmlProps);
  })
);
export {
  Tab,
  useTab
};
