"use client";
import {
  TabScopedContextProvider,
  useTabProviderContext
} from "../__chunks/QGC5LOGZ.js";
import {
  useComposite
} from "../__chunks/NSTBQJLB.js";
import "../__chunks/5VQZOHHZ.js";
import "../__chunks/APTFW6PT.js";
import "../__chunks/OE2EFRVA.js";
import "../__chunks/SWN3JYXT.js";
import "../__chunks/5CPL3B7G.js";
import {
  createElement,
  createHook,
  forwardRef
} from "../__chunks/VOQWLFSQ.js";
import {
  useWrapElement
} from "../__chunks/5GGHRIN3.js";
import "../__chunks/SK3NAZA3.js";
import {
  __objRest,
  __spreadValues
} from "../__chunks/3YLGPPWQ.js";

// src/tab/tab-list.tsx
import { invariant } from "@ariakit/core/utils/misc";
import { jsx } from "react/jsx-runtime";
var TagName = "div";
var useTabList = createHook(
  function useTabList2(_a) {
    var _b = _a, { store } = _b, props = __objRest(_b, ["store"]);
    const context = useTabProviderContext();
    store = store || context;
    invariant(
      store,
      process.env.NODE_ENV !== "production" && "TabList must receive a `store` prop or be wrapped in a TabProvider component."
    );
    const orientation = store.useState(
      (state) => state.orientation === "both" ? void 0 : state.orientation
    );
    props = useWrapElement(
      props,
      (element) => /* @__PURE__ */ jsx(TabScopedContextProvider, { value: store, children: element }),
      [store]
    );
    if (store.composite) {
      props = __spreadValues({
        focusable: false
      }, props);
    }
    props = __spreadValues({
      role: "tablist",
      "aria-orientation": orientation
    }, props);
    props = useComposite(__spreadValues({ store }, props));
    return props;
  }
);
var TabList = forwardRef(function TabList2(props) {
  const htmlProps = useTabList(props);
  return createElement(TagName, htmlProps);
});
export {
  TabList,
  useTabList
};
