"use client";
import {
  useSelectContext
} from "../__chunks/LM7KIZUU.js";
import {
  useCompositeRenderer
} from "../__chunks/JAZDGUNC.js";
import {
  getCollectionRendererItem,
  getCollectionRendererItemId
} from "../__chunks/FVD56SIN.js";
import "../__chunks/Y67KZUMI.js";
import "../__chunks/T2AZQXQU.js";
import "../__chunks/ABN76PSX.js";
import "../__chunks/APTFW6PT.js";
import {
  useStoreState
} from "../__chunks/RTNCFSKZ.js";
import "../__chunks/5CPL3B7G.js";
import {
  createElement,
  forwardRef
} from "../__chunks/VOQWLFSQ.js";
import "../__chunks/5GGHRIN3.js";
import "../__chunks/SK3NAZA3.js";
import {
  __objRest,
  __spreadValues
} from "../__chunks/3YLGPPWQ.js";

// src/select/select-renderer.tsx
import { toArray } from "@ariakit/core/utils/array";
import { useMemo } from "react";
var TagName = "div";
function getItemObject(item) {
  if (!item || typeof item !== "object") {
    return { value: `${item}` };
  }
  return item;
}
function findIndicesByValue(items, value) {
  var _a;
  const values = toArray(value);
  const indices = [];
  for (const [index, item] of items.entries()) {
    if (indices.length === values.length) break;
    const object = getItemObject(item);
    if (object.value != null && values.includes(object.value)) {
      indices.push(index);
    } else if ((_a = object.items) == null ? void 0 : _a.length) {
      const childIndices = findIndicesByValue(object.items, value);
      if (childIndices.length) {
        indices.push(index);
      }
    }
  }
  return indices;
}
function useSelectRenderer(_a) {
  var _b = _a, {
    store,
    orientation: orientationProp,
    persistentIndices: persistentIndicesProp,
    items: itemsProp,
    value: valueProp
  } = _b, props = __objRest(_b, [
    "store",
    "orientation",
    "persistentIndices",
    "items",
    "value"
  ]);
  const context = useSelectContext();
  store = store || context;
  const items = useStoreState(store, (state) => {
    if (!state) return itemsProp;
    if (!state.mounted) return 0;
    return itemsProp != null ? itemsProp : state.items;
  });
  const value = useStoreState(store, (state) => valueProp != null ? valueProp : state == null ? void 0 : state.value);
  const valueIndices = useMemo(() => {
    if (!items) return [];
    if (value == null) return [];
    if (typeof items === "number") return [];
    if (!items.length) return [];
    return findIndicesByValue(items, value);
  }, [items, value]);
  const persistentIndices = useMemo(() => {
    if (persistentIndicesProp) {
      return [...persistentIndicesProp, ...valueIndices];
    }
    return valueIndices;
  }, [valueIndices, persistentIndicesProp]);
  return useCompositeRenderer(__spreadValues({
    store,
    items,
    persistentIndices
  }, props));
}
var SelectRenderer = forwardRef(function SelectRenderer2(props) {
  const htmlProps = useSelectRenderer(props);
  return createElement(TagName, htmlProps);
});
export {
  SelectRenderer,
  getCollectionRendererItem as getSelectRendererItem,
  getCollectionRendererItemId as getSelectRendererItemId
};
