"use client";
import {
  useMenuItem
} from "../__chunks/BSJHR6LI.js";
import {
  MenuItemCheckedContext,
  useMenuScopedContext
} from "../__chunks/4QTMCR75.js";
import "../__chunks/JUCYQ5OS.js";
import "../__chunks/7Z7JH52O.js";
import {
  useRadio
} from "../__chunks/SQZLCNLX.js";
import "../__chunks/BGBYET7R.js";
import "../__chunks/IABE5EV2.js";
import "../__chunks/SBSPVDDI.js";
import "../__chunks/5VQZOHHZ.js";
import "../__chunks/Y62RTBST.js";
import "../__chunks/Y67KZUMI.js";
import "../__chunks/T2AZQXQU.js";
import "../__chunks/ABN76PSX.js";
import "../__chunks/APTFW6PT.js";
import "../__chunks/2W3RN7C5.js";
import "../__chunks/OE2EFRVA.js";
import "../__chunks/SWN3JYXT.js";
import "../__chunks/RTNCFSKZ.js";
import "../__chunks/5CPL3B7G.js";
import {
  createElement,
  createHook,
  forwardRef,
  memo
} from "../__chunks/VOQWLFSQ.js";
import {
  useInitialValue,
  useWrapElement
} from "../__chunks/5GGHRIN3.js";
import "../__chunks/SK3NAZA3.js";
import {
  __objRest,
  __spreadValues
} from "../__chunks/3YLGPPWQ.js";

// src/menu/menu-item-radio.tsx
import { invariant } from "@ariakit/core/utils/misc";
import { useEffect } from "react";
import { jsx } from "react/jsx-runtime";
var TagName = "div";
function getValue(prevValue, value, checked) {
  if (checked === void 0) return prevValue;
  if (checked) return value;
  return prevValue;
}
var useMenuItemRadio = createHook(
  function useMenuItemRadio2(_a) {
    var _b = _a, {
      store,
      name,
      value,
      checked,
      onChange: onChangeProp,
      hideOnClick = false
    } = _b, props = __objRest(_b, [
      "store",
      "name",
      "value",
      "checked",
      "onChange",
      "hideOnClick"
    ]);
    const context = useMenuScopedContext();
    store = store || context;
    invariant(
      store,
      process.env.NODE_ENV !== "production" && "MenuItemRadio must be wrapped in a MenuList or Menu component"
    );
    const defaultChecked = useInitialValue(props.defaultChecked);
    useEffect(() => {
      store == null ? void 0 : store.setValue(name, (prevValue = false) => {
        return getValue(prevValue, value, defaultChecked);
      });
    }, [store, name, value, defaultChecked]);
    useEffect(() => {
      if (checked === void 0) return;
      store == null ? void 0 : store.setValue(name, (prevValue) => {
        return getValue(prevValue, value, checked);
      });
    }, [store, name, value, checked]);
    const isChecked = store.useState((state) => state.values[name] === value);
    props = useWrapElement(
      props,
      (element) => /* @__PURE__ */ jsx(MenuItemCheckedContext.Provider, { value: !!isChecked, children: element }),
      [isChecked]
    );
    props = __spreadValues({
      role: "menuitemradio"
    }, props);
    props = useRadio(__spreadValues({
      name,
      value,
      checked: isChecked,
      onChange(event) {
        onChangeProp == null ? void 0 : onChangeProp(event);
        if (event.defaultPrevented) return;
        const element = event.currentTarget;
        store == null ? void 0 : store.setValue(name, (prevValue) => {
          return getValue(prevValue, value, checked != null ? checked : element.checked);
        });
      }
    }, props));
    props = useMenuItem(__spreadValues({ store, hideOnClick }, props));
    return props;
  }
);
var MenuItemRadio = memo(
  forwardRef(function MenuItemRadio2(props) {
    const htmlProps = useMenuItemRadio(props);
    return createElement(TagName, htmlProps);
  })
);
export {
  MenuItemRadio,
  useMenuItemRadio
};
