"use client";
import {
  useMenuItem
} from "../__chunks/BSJHR6LI.js";
import {
  useMenuScopedContext
} from "../__chunks/4QTMCR75.js";
import "../__chunks/JUCYQ5OS.js";
import "../__chunks/7Z7JH52O.js";
import "../__chunks/IABE5EV2.js";
import "../__chunks/SBSPVDDI.js";
import "../__chunks/5VQZOHHZ.js";
import "../__chunks/Y62RTBST.js";
import "../__chunks/Y67KZUMI.js";
import "../__chunks/T2AZQXQU.js";
import "../__chunks/ABN76PSX.js";
import "../__chunks/APTFW6PT.js";
import {
  useCheckboxStore
} from "../__chunks/KPSSTU6K.js";
import {
  useCheckbox
} from "../__chunks/KPUWHTQJ.js";
import "../__chunks/2W3RN7C5.js";
import "../__chunks/OE2EFRVA.js";
import "../__chunks/SWN3JYXT.js";
import "../__chunks/EYKMH5G5.js";
import "../__chunks/WWPIG7YG.js";
import "../__chunks/RTNCFSKZ.js";
import "../__chunks/5CPL3B7G.js";
import {
  createElement,
  createHook,
  forwardRef,
  memo
} from "../__chunks/VOQWLFSQ.js";
import {
  useInitialValue
} from "../__chunks/5GGHRIN3.js";
import "../__chunks/SK3NAZA3.js";
import {
  __objRest,
  __spreadValues
} from "../__chunks/3YLGPPWQ.js";

// src/menu/menu-item-checkbox.tsx
import { invariant, shallowEqual } from "@ariakit/core/utils/misc";
import { useEffect } from "react";
var TagName = "div";
function getPrimitiveValue(value) {
  if (Array.isArray(value)) {
    return value.toString();
  }
  return value;
}
function getValue(storeValue, value, checked) {
  if (value === void 0) {
    if (Array.isArray(storeValue)) return storeValue;
    return !!checked;
  }
  const primitiveValue = getPrimitiveValue(value);
  if (!Array.isArray(storeValue)) {
    if (checked) {
      return primitiveValue;
    }
    return storeValue === primitiveValue ? false : storeValue;
  }
  if (checked) {
    if (storeValue.includes(primitiveValue)) {
      return storeValue;
    }
    return [...storeValue, primitiveValue];
  }
  return storeValue.filter((v) => v !== primitiveValue);
}
var useMenuItemCheckbox = createHook(
  function useMenuItemCheckbox2(_a) {
    var _b = _a, {
      store,
      name,
      value,
      checked,
      defaultChecked: defaultCheckedProp,
      hideOnClick = false
    } = _b, props = __objRest(_b, [
      "store",
      "name",
      "value",
      "checked",
      "defaultChecked",
      "hideOnClick"
    ]);
    const context = useMenuScopedContext();
    store = store || context;
    invariant(
      store,
      process.env.NODE_ENV !== "production" && "MenuItemCheckbox must be wrapped in a MenuList or Menu component"
    );
    const defaultChecked = useInitialValue(defaultCheckedProp);
    useEffect(() => {
      store == null ? void 0 : store.setValue(name, (prevValue = []) => {
        if (!defaultChecked) return prevValue;
        return getValue(prevValue, value, true);
      });
    }, [store, name, value, defaultChecked]);
    useEffect(() => {
      if (checked === void 0) return;
      store == null ? void 0 : store.setValue(name, (prevValue) => {
        return getValue(prevValue, value, checked);
      });
    }, [store, name, value, checked]);
    const checkboxStore = useCheckboxStore({
      value: store.useState((state) => state.values[name]),
      setValue(internalValue) {
        store == null ? void 0 : store.setValue(name, () => {
          if (checked === void 0) return internalValue;
          const nextValue = getValue(internalValue, value, checked);
          if (!Array.isArray(nextValue)) return nextValue;
          if (!Array.isArray(internalValue)) return nextValue;
          if (shallowEqual(internalValue, nextValue)) return internalValue;
          return nextValue;
        });
      }
    });
    props = __spreadValues({
      role: "menuitemcheckbox"
    }, props);
    props = useCheckbox(__spreadValues({
      store: checkboxStore,
      name,
      value,
      checked
    }, props));
    props = useMenuItem(__spreadValues({ store, hideOnClick }, props));
    return props;
  }
);
var MenuItemCheckbox = memo(
  forwardRef(function MenuItemCheckbox2(props) {
    const htmlProps = useMenuItemCheckbox(props);
    return createElement(TagName, htmlProps);
  })
);
export {
  MenuItemCheckbox,
  useMenuItemCheckbox
};
