"use client";
import {
  useFormContext
} from "../__chunks/GSXI3IAI.js";
import {
  useButton
} from "../__chunks/XCKGTAUF.js";
import "../__chunks/2W3RN7C5.js";
import "../__chunks/OE2EFRVA.js";
import "../__chunks/SWN3JYXT.js";
import "../__chunks/5CPL3B7G.js";
import {
  createElement,
  createHook,
  forwardRef
} from "../__chunks/VOQWLFSQ.js";
import {
  useEvent
} from "../__chunks/5GGHRIN3.js";
import "../__chunks/SK3NAZA3.js";
import {
  __objRest,
  __spreadProps,
  __spreadValues
} from "../__chunks/3YLGPPWQ.js";

// src/form/form-remove.tsx
import { isTextField } from "@ariakit/core/utils/dom";
import { invariant } from "@ariakit/core/utils/misc";
var TagName = "button";
function findNextOrPreviousField(items, name, index) {
  const fields = items == null ? void 0 : items.filter(
    (item) => item.type === "field" && item.name.startsWith(name)
  );
  const regex = new RegExp(`^${name}\\.(\\d+)`);
  const nextField = fields == null ? void 0 : fields.find((field) => {
    const fieldIndex = field.name.replace(regex, "$1");
    return Number.parseInt(fieldIndex) > index;
  });
  if (nextField) return nextField;
  return fields == null ? void 0 : fields.reverse().find((field) => {
    const fieldIndex = field.name.replace(regex, "$1");
    return Number.parseInt(fieldIndex) < index;
  });
}
function findPushButton(items, name) {
  return items == null ? void 0 : items.find((item) => item.type === "button" && item.name === name);
}
var useFormRemove = createHook(
  function useFormRemove2(_a) {
    var _b = _a, {
      store,
      name: nameProp,
      index,
      autoFocusOnClick = true
    } = _b, props = __objRest(_b, [
      "store",
      "name",
      "index",
      "autoFocusOnClick"
    ]);
    const context = useFormContext();
    store = store || context;
    invariant(
      store,
      process.env.NODE_ENV !== "production" && "FormRemove must be wrapped in a Form component."
    );
    const name = `${nameProp}`;
    const onClickProp = props.onClick;
    const onClick = useEvent((event) => {
      var _a2;
      onClickProp == null ? void 0 : onClickProp(event);
      if (event.defaultPrevented) return;
      if (!store) return;
      store.removeValue(name, index);
      if (!autoFocusOnClick) return;
      const { items } = store.getState();
      const item = findNextOrPreviousField(items, name, index);
      const element = item == null ? void 0 : item.element;
      if (element) {
        element.focus();
        if (isTextField(element)) {
          element.select();
        }
      } else {
        const pushButton = findPushButton(items, name);
        (_a2 = pushButton == null ? void 0 : pushButton.element) == null ? void 0 : _a2.focus();
      }
    });
    props = __spreadProps(__spreadValues({}, props), {
      onClick
    });
    props = useButton(props);
    return props;
  }
);
var FormRemove = forwardRef(function FormRemove2(props) {
  const htmlProps = useFormRemove(props);
  return createElement(TagName, htmlProps);
});
export {
  FormRemove,
  useFormRemove
};
