"use client";
import {
  useFormContext
} from "../__chunks/GSXI3IAI.js";
import {
  useCollectionItem
} from "../__chunks/Y62RTBST.js";
import "../__chunks/5CPL3B7G.js";
import {
  createElement,
  createHook,
  forwardRef,
  memo
} from "../__chunks/VOQWLFSQ.js";
import {
  useEvent,
  useId,
  useMergeRefs,
  useTagName
} from "../__chunks/5GGHRIN3.js";
import "../__chunks/SK3NAZA3.js";
import {
  __objRest,
  __spreadProps,
  __spreadValues
} from "../__chunks/3YLGPPWQ.js";

// src/form/form-label.tsx
import { getFirstTabbableIn } from "@ariakit/core/utils/focus";
import { invariant } from "@ariakit/core/utils/misc";
import { useCallback, useRef } from "react";
import { jsx } from "react/jsx-runtime";
var TagName = "label";
function supportsNativeLabel(tagName) {
  return tagName === "input" || tagName === "textarea" || tagName === "select" || tagName === "meter" || tagName === "progress";
}
var useFormLabel = createHook(
  function useFormLabel2(_a) {
    var _b = _a, {
      store,
      name: nameProp,
      getItem: getItemProp
    } = _b, props = __objRest(_b, [
      "store",
      "name",
      "getItem"
    ]);
    const context = useFormContext();
    store = store || context;
    invariant(
      store,
      process.env.NODE_ENV !== "production" && "FormLabel must be wrapped in a Form component."
    );
    const id = useId(props.id);
    const ref = useRef(null);
    const name = `${nameProp}`;
    const getItem = useCallback(
      (item) => {
        const nextItem = __spreadProps(__spreadValues({}, item), { id: id || item.id, name, type: "label" });
        if (getItemProp) {
          return getItemProp(nextItem);
        }
        return nextItem;
      },
      [id, name, getItemProp]
    );
    const field = store.useState(
      (state) => state.items.find((item) => item.type === "field" && item.name === name)
    );
    const fieldTagName = useTagName(field == null ? void 0 : field.element, "input");
    const isNativeLabel = supportsNativeLabel(fieldTagName);
    const onClickProp = props.onClick;
    const onClick = useEvent((event) => {
      onClickProp == null ? void 0 : onClickProp(event);
      if (event.defaultPrevented) return;
      if (isNativeLabel) return;
      const fieldElement = field == null ? void 0 : field.element;
      if (!fieldElement) return;
      queueMicrotask(() => {
        const focusableElement = getFirstTabbableIn(fieldElement, true, true);
        focusableElement == null ? void 0 : focusableElement.focus();
        const role = focusableElement == null ? void 0 : focusableElement.getAttribute("role");
        if (role === "combobox") return;
        focusableElement == null ? void 0 : focusableElement.click();
      });
    });
    props = __spreadProps(__spreadValues({
      id,
      render: isNativeLabel ? /* @__PURE__ */ jsx("label", {}) : /* @__PURE__ */ jsx("span", {}),
      htmlFor: isNativeLabel ? field == null ? void 0 : field.id : void 0
    }, props), {
      ref: useMergeRefs(ref, props.ref),
      onClick
    });
    if (!isNativeLabel) {
      props = __spreadProps(__spreadValues({}, props), {
        style: __spreadValues({
          cursor: "default"
        }, props.style)
      });
    }
    props = useCollectionItem(__spreadProps(__spreadValues({ store }, props), { getItem }));
    return props;
  }
);
var FormLabel = memo(
  forwardRef(function FormLabel2(props) {
    const htmlProps = useFormLabel(props);
    return createElement(TagName, htmlProps);
  })
);
export {
  FormLabel,
  useFormLabel
};
