"use client";
import {
  useFormContext
} from "../__chunks/GSXI3IAI.js";
import {
  useCollectionItem
} from "../__chunks/Y62RTBST.js";
import "../__chunks/5CPL3B7G.js";
import {
  createElement,
  createHook,
  forwardRef,
  memo
} from "../__chunks/VOQWLFSQ.js";
import {
  useId,
  useMergeRefs
} from "../__chunks/5GGHRIN3.js";
import "../__chunks/SK3NAZA3.js";
import {
  __objRest,
  __spreadProps,
  __spreadValues
} from "../__chunks/3YLGPPWQ.js";

// src/form/form-error.tsx
import { invariant } from "@ariakit/core/utils/misc";
import { useCallback, useRef } from "react";
var TagName = "div";
var useFormError = createHook(
  function useFormError2(_a) {
    var _b = _a, {
      store,
      name: nameProp,
      getItem: getItemProp
    } = _b, props = __objRest(_b, [
      "store",
      "name",
      "getItem"
    ]);
    const context = useFormContext();
    store = store || context;
    invariant(
      store,
      process.env.NODE_ENV !== "production" && "FormError must be wrapped in a Form component."
    );
    const id = useId(props.id);
    const ref = useRef(null);
    const name = `${nameProp}`;
    const getItem = useCallback(
      (item) => {
        const nextItem = __spreadProps(__spreadValues({}, item), { id: id || item.id, name, type: "error" });
        if (getItemProp) {
          return getItemProp(nextItem);
        }
        return nextItem;
      },
      [id, name, getItemProp]
    );
    const children = store.useState(() => {
      const error = store == null ? void 0 : store.getError(name);
      if (error == null) return;
      if (!(store == null ? void 0 : store.getFieldTouched(name))) return;
      return error;
    });
    props = __spreadProps(__spreadValues({
      id,
      role: "alert",
      children
    }, props), {
      ref: useMergeRefs(ref, props.ref)
    });
    props = useCollectionItem(__spreadProps(__spreadValues({ store }, props), { getItem }));
    return props;
  }
);
var FormError = memo(
  forwardRef(function FormError2(props) {
    const htmlProps = useFormError(props);
    return createElement(TagName, htmlProps);
  })
);
export {
  FormError,
  useFormError
};
