"use client";
import {
  FocusTrap
} from "../__chunks/S2F2XXEH.js";
import "../__chunks/DXGKYUAD.js";
import {
  createElement,
  createHook,
  forwardRef
} from "../__chunks/VOQWLFSQ.js";
import {
  useMergeRefs,
  useWrapElement
} from "../__chunks/5GGHRIN3.js";
import "../__chunks/SK3NAZA3.js";
import {
  __objRest,
  __spreadProps,
  __spreadValues
} from "../__chunks/3YLGPPWQ.js";

// src/focus-trap/focus-trap-region.tsx
import { getAllTabbableIn } from "@ariakit/core/utils/focus";
import { removeUndefinedValues } from "@ariakit/core/utils/misc";
import { useRef } from "react";
import { Fragment, jsx, jsxs } from "react/jsx-runtime";
var TagName = "div";
var useFocusTrapRegion = createHook(
  function useFocusTrapRegion2(_a) {
    var _b = _a, { enabled = false } = _b, props = __objRest(_b, ["enabled"]);
    const ref = useRef(null);
    props = useWrapElement(
      props,
      (element) => {
        const renderFocusTrap = () => {
          if (!enabled) return null;
          return /* @__PURE__ */ jsx(
            FocusTrap,
            {
              onFocus: (event) => {
                const container = ref.current;
                if (!container) return;
                const tabbables = getAllTabbableIn(container, true);
                const first = tabbables[0];
                const last = tabbables[tabbables.length - 1];
                if (!tabbables.length) {
                  container.focus();
                  return;
                }
                if (event.relatedTarget === first) {
                  last == null ? void 0 : last.focus();
                } else {
                  first == null ? void 0 : first.focus();
                }
              }
            }
          );
        };
        return /* @__PURE__ */ jsxs(Fragment, { children: [
          renderFocusTrap(),
          element,
          renderFocusTrap()
        ] });
      },
      [enabled]
    );
    props = __spreadProps(__spreadValues({}, props), {
      ref: useMergeRefs(ref, props.ref)
    });
    return removeUndefinedValues(props);
  }
);
var FocusTrapRegion = forwardRef(function FocusTrapRegion2(props) {
  const htmlProps = useFocusTrapRegion(props);
  return createElement(TagName, htmlProps);
});
export {
  FocusTrapRegion,
  useFocusTrapRegion
};
