import type { ElementType } from "react";
import { type CollectionItemOptions } from "../collection/collection-item-offscreen.tsx";
import type { Props } from "../utils/types.ts";
import * as Base from "./composite-item.tsx";
declare const TagName = "button";
type TagName = typeof TagName;
export declare function useCompositeItemOffscreen<T extends ElementType, P extends CompositeItemProps<T>>({ store, offscreenBehavior, disabled, value, ...props }: P): {
    id: string | undefined;
    active: boolean;
    ref: import("react").RefCallback<HTMLDivElement>;
    "data-offscreen": true | undefined;
} | {
    children: import("react").ComponentPropsWithRef<T>[string] | undefined;
    role: string | undefined;
    "aria-disabled": true | undefined;
    "data-offscreen-id": string | undefined;
    id: string | undefined;
    active: boolean;
    ref: import("react").RefCallback<HTMLDivElement>;
    "data-offscreen": true | undefined;
};
export declare const CompositeItem: ({ offscreenBehavior, offscreenRoot, ...props }: CompositeItemProps) => import("react/jsx-runtime").JSX.Element;
export interface CompositeItemOptions<T extends ElementType = TagName> extends Base.CompositeItemOptions<T>, Omit<CollectionItemOptions<T>, "store"> {
}
export type CompositeItemProps<T extends ElementType = TagName> = Props<T, CompositeItemOptions<T>>;
export {};
