"use client";
import {
  selectTextField
} from "../__chunks/5VQZOHHZ.js";
import {
  createElement,
  createHook,
  forwardRef,
  memo
} from "../__chunks/VOQWLFSQ.js";
import {
  useEvent
} from "../__chunks/5GGHRIN3.js";
import "../__chunks/SK3NAZA3.js";
import {
  __objRest,
  __spreadProps,
  __spreadValues
} from "../__chunks/3YLGPPWQ.js";

// src/composite/composite-input.tsx
import {
  getDocument,
  getTextboxSelection,
  isTextField
} from "@ariakit/core/utils/dom";
import { removeUndefinedValues } from "@ariakit/core/utils/misc";
import { useEffect } from "react";
var TagName = "input";
function getValueLength(element) {
  if (isTextField(element)) {
    return element.value.length;
  } else if (element.isContentEditable) {
    const range = getDocument(element).createRange();
    range.selectNodeContents(element);
    return range.toString().length;
  }
  return 0;
}
var useCompositeInput = createHook(
  function useCompositeInput2(_a) {
    var _b = _a, { store } = _b, props = __objRest(_b, ["store"]);
    const onKeyDownCaptureProp = props.onKeyDownCapture;
    if (process.env.NODE_ENV !== "production") {
      useEffect(() => {
        console.warn(
          "CompositeInput is deprecated. Use `<CompositeItem render={<input />}>` instead."
        );
      }, []);
    }
    const onKeyDownCapture = useEvent((event) => {
      onKeyDownCaptureProp == null ? void 0 : onKeyDownCaptureProp(event);
      if (event.defaultPrevented) return;
      const element = event.currentTarget;
      if (!element.isContentEditable && !isTextField(element)) return;
      const selection = getTextboxSelection(element);
      const { orientation } = (store == null ? void 0 : store.getState()) || {};
      const isHorizontal = orientation !== "vertical";
      const isVertical = orientation !== "horizontal";
      const isLeft = isHorizontal && event.key === "ArrowLeft";
      const isRight = isHorizontal && event.key === "ArrowRight";
      const isUp = isVertical && event.key === "ArrowUp";
      const isDown = isVertical && event.key === "ArrowDown";
      if (isRight || isDown) {
        if (selection.end !== getValueLength(element)) {
          event.stopPropagation();
        }
      } else if (isLeft || isUp) {
        if (selection.start !== 0) {
          event.stopPropagation();
        }
      }
    });
    const onFocusProp = props.onFocus;
    const onFocus = useEvent((event) => {
      onFocusProp == null ? void 0 : onFocusProp(event);
      if (event.defaultPrevented) return;
      selectTextField(event.currentTarget);
    });
    props = __spreadProps(__spreadValues({}, props), {
      onKeyDownCapture,
      onFocus
    });
    return removeUndefinedValues(props);
  }
);
var CompositeInput = memo(
  forwardRef(function CompositeInput2(props) {
    const htmlProps = useCompositeInput(props);
    return createElement(TagName, htmlProps);
  })
);
export {
  CompositeInput,
  useCompositeInput
};
