"use client";
import {
  useComboboxProviderContext
} from "../__chunks/OLVWQA7U.js";
import "../__chunks/Y67KZUMI.js";
import "../__chunks/T2AZQXQU.js";
import "../__chunks/ABN76PSX.js";
import "../__chunks/APTFW6PT.js";
import {
  useButton
} from "../__chunks/XCKGTAUF.js";
import "../__chunks/2W3RN7C5.js";
import "../__chunks/OE2EFRVA.js";
import "../__chunks/SWN3JYXT.js";
import "../__chunks/5CPL3B7G.js";
import {
  createElement,
  createHook,
  forwardRef
} from "../__chunks/VOQWLFSQ.js";
import {
  useEvent,
  useWrapElement
} from "../__chunks/5GGHRIN3.js";
import "../__chunks/SK3NAZA3.js";
import {
  __objRest,
  __spreadProps,
  __spreadValues
} from "../__chunks/3YLGPPWQ.js";

// src/combobox/combobox-cancel.tsx
import { invariant } from "@ariakit/core/utils/misc";
import { Fragment } from "react";
import { jsx, jsxs } from "react/jsx-runtime";
var TagName = "button";
var children = /* @__PURE__ */ jsxs(
  "svg",
  {
    "aria-hidden": "true",
    display: "block",
    viewBox: "0 0 16 16",
    fill: "none",
    stroke: "currentColor",
    strokeLinecap: "round",
    strokeLinejoin: "round",
    strokeWidth: 1.5,
    width: "1em",
    height: "1em",
    pointerEvents: "none",
    children: [
      /* @__PURE__ */ jsx("line", { x1: "5", y1: "5", x2: "11", y2: "11" }),
      /* @__PURE__ */ jsx("line", { x1: "5", y1: "11", x2: "11", y2: "5" })
    ]
  }
);
var useComboboxCancel = createHook(
  function useComboboxCancel2(_a) {
    var _b = _a, { store, hideWhenEmpty } = _b, props = __objRest(_b, ["store", "hideWhenEmpty"]);
    const context = useComboboxProviderContext();
    store = store || context;
    invariant(
      store,
      process.env.NODE_ENV !== "production" && "ComboboxCancel must receive a `store` prop or be wrapped in a ComboboxProvider component."
    );
    const onClickProp = props.onClick;
    const onClick = useEvent((event) => {
      onClickProp == null ? void 0 : onClickProp(event);
      if (event.defaultPrevented) return;
      store == null ? void 0 : store.setValue("");
      store == null ? void 0 : store.move(null);
    });
    const comboboxId = store.useState((state) => {
      var _a2;
      return (_a2 = state.baseElement) == null ? void 0 : _a2.id;
    });
    const empty = store.useState((state) => state.value === "");
    props = useWrapElement(
      props,
      (element) => {
        if (!hideWhenEmpty) return element;
        if (empty) return /* @__PURE__ */ jsx(Fragment, {});
        return element;
      },
      [hideWhenEmpty, empty]
    );
    props = __spreadProps(__spreadValues({
      children,
      "aria-label": "Clear input",
      // This aria-controls will ensure the combobox popup remains visible when
      // this element gets focused. This logic is done in the ComboboxPopover
      // component.
      "aria-controls": comboboxId
    }, props), {
      onClick
    });
    props = useButton(props);
    return props;
  }
);
var ComboboxCancel = forwardRef(function ComboboxCancel2(props) {
  const htmlProps = useComboboxCancel(props);
  return createElement(TagName, htmlProps);
});
export {
  ComboboxCancel,
  useComboboxCancel
};
