"use client";
import {
  useDisclosure
} from "./NMGNQVTG.js";
import {
  useDialogProviderContext
} from "./T2AZQXQU.js";
import {
  createElement,
  createHook,
  forwardRef
} from "./VOQWLFSQ.js";
import {
  __objRest,
  __spreadValues
} from "./3YLGPPWQ.js";

// src/dialog/dialog-disclosure.tsx
import { getPopupRole } from "@ariakit/core/utils/dom";
import { invariant } from "@ariakit/core/utils/misc";
var TagName = "button";
var useDialogDisclosure = createHook(
  function useDialogDisclosure2(_a) {
    var _b = _a, { store } = _b, props = __objRest(_b, ["store"]);
    const context = useDialogProviderContext();
    store = store || context;
    invariant(
      store,
      process.env.NODE_ENV !== "production" && "DialogDisclosure must receive a `store` prop or be wrapped in a DialogProvider component."
    );
    const contentElement = store.useState("contentElement");
    props = __spreadValues({
      "aria-haspopup": getPopupRole(contentElement, "dialog")
    }, props);
    props = useDisclosure(__spreadValues({ store }, props));
    return props;
  }
);
var DialogDisclosure = forwardRef(function DialogDisclosure2(props) {
  const htmlProps = useDialogDisclosure(props);
  return createElement(TagName, htmlProps);
});

export {
  useDialogDisclosure,
  DialogDisclosure
};
