"use client";
import {
  isFocusTrap
} from "./IGR4SXG2.js";
import {
  supportsInert
} from "./677M2CI3.js";
import {
  hideElementFromAccessibilityTree
} from "./S7U6BLGA.js";
import {
  walkTreeOutside
} from "./AOUGVQZ3.js";
import {
  assignStyle,
  orchestrate,
  setAttribute,
  setProperty
} from "./K2ZF5NU7.js";
import {
  isBackdrop
} from "./63XF7ACK.js";

// src/dialog/utils/disable-tree.ts
import { contains } from "@ariakit/core/utils/dom";
import { getAllTabbableIn } from "@ariakit/core/utils/focus";
import { chain, noop } from "@ariakit/core/utils/misc";
function disableTree(element, ignoredElements) {
  if (!("style" in element)) return noop;
  if (supportsInert()) {
    return setProperty(element, "inert", true);
  }
  const tabbableElements = getAllTabbableIn(element, true);
  const enableElements = tabbableElements.map((element2) => {
    if (ignoredElements == null ? void 0 : ignoredElements.some((el) => el && contains(el, element2))) return noop;
    const restoreFocusMethod = orchestrate(element2, "focus", () => {
      element2.focus = noop;
      return () => {
        delete element2.focus;
      };
    });
    return chain(setAttribute(element2, "tabindex", "-1"), restoreFocusMethod);
  });
  return chain(
    ...enableElements,
    hideElementFromAccessibilityTree(element),
    assignStyle(element, {
      pointerEvents: "none",
      userSelect: "none",
      cursor: "default"
    })
  );
}
function disableTreeOutside(id, elements) {
  const cleanups = [];
  const ids = elements.map((el) => el == null ? void 0 : el.id);
  walkTreeOutside(
    id,
    elements,
    (element) => {
      if (isBackdrop(element, ...ids)) return;
      if (isFocusTrap(element, ...ids)) return;
      cleanups.unshift(disableTree(element, elements));
    },
    (element) => {
      if (!element.hasAttribute("role")) return;
      if (elements.some((el) => el && contains(el, element))) return;
      cleanups.unshift(setAttribute(element, "role", "none"));
    }
  );
  const restoreTreeOutside = () => {
    for (const cleanup of cleanups) {
      cleanup();
    }
  };
  return restoreTreeOutside;
}

export {
  disableTree,
  disableTreeOutside
};
