"use client";
import {
  useCollectionContext
} from "./5CPL3B7G.js";
import {
  createElement,
  createHook,
  forwardRef
} from "./VOQWLFSQ.js";
import {
  useId,
  useMergeRefs
} from "./5GGHRIN3.js";
import {
  __objRest,
  __spreadProps,
  __spreadValues
} from "./3YLGPPWQ.js";

// src/collection/collection-item.tsx
import { identity, removeUndefinedValues } from "@ariakit/core/utils/misc";
import { useEffect, useRef } from "react";
var TagName = "div";
var useCollectionItem = createHook(
  function useCollectionItem2(_a) {
    var _b = _a, {
      store,
      shouldRegisterItem = true,
      getItem = identity,
      element: element
    } = _b, props = __objRest(_b, [
      "store",
      "shouldRegisterItem",
      "getItem",
      // @ts-expect-error This prop may come from a collection renderer.
      "element"
    ]);
    const context = useCollectionContext();
    store = store || context;
    const id = useId(props.id);
    const ref = useRef(element);
    useEffect(() => {
      const element2 = ref.current;
      if (!id) return;
      if (!element2) return;
      if (!shouldRegisterItem) return;
      const item = getItem({ id, element: element2 });
      return store == null ? void 0 : store.renderItem(item);
    }, [id, shouldRegisterItem, getItem, store]);
    props = __spreadProps(__spreadValues({}, props), {
      ref: useMergeRefs(ref, props.ref)
    });
    return removeUndefinedValues(props);
  }
);
var CollectionItem = forwardRef(function CollectionItem2(props) {
  const htmlProps = useCollectionItem(props);
  return createElement(TagName, htmlProps);
});

export {
  useCollectionItem,
  CollectionItem
};
