"use client";
import {
  CompositeItem
} from "./SBSPVDDI.js";
import {
  useCollectionItemOffscreen
} from "./OQDUQELZ.js";
import {
  Role
} from "./QJ4LGO2N.js";
import {
  useCompositeContext
} from "./APTFW6PT.js";
import {
  useStoreStateObject
} from "./RTNCFSKZ.js";
import {
  forwardRef
} from "./VOQWLFSQ.js";
import {
  useId,
  useMergeRefs
} from "./5GGHRIN3.js";
import {
  __objRest,
  __spreadProps,
  __spreadValues
} from "./3YLGPPWQ.js";

// src/composite/composite-item-offscreen.tsx
import { getPopupItemRole } from "@ariakit/core/utils/dom";
import { jsx } from "react/jsx-runtime";
var TagName = "button";
function useCompositeItemOffscreen(_a) {
  var _b = _a, { store, offscreenBehavior = "active", disabled, value } = _b, props = __objRest(_b, ["store", "offscreenBehavior", "disabled", "value"]);
  const context = useCompositeContext();
  store = store || context;
  const id = useId(props.id);
  const { storeId, active, listElement, offscreenRoot } = useStoreStateObject(
    store,
    {
      storeId: "id",
      active(state) {
        if (!state) return;
        if (!("selectedValue" in state) && "value" in state) {
          if (state.value === value) return true;
        }
        return !!id && state.activeId === id;
      },
      listElement(state) {
        if (!state) return;
        if (!("listElement" in state)) return;
        return state.listElement;
      },
      offscreenRoot(state) {
        if (props.offscreenRoot) return props.offscreenRoot;
        if (!state) return;
        if (!("contentElement" in state)) return;
        return state.contentElement || null;
      }
    }
  );
  const offscreenProps = useCollectionItemOffscreen(__spreadProps(__spreadValues({
    id,
    store,
    offscreenBehavior: active ? "active" : offscreenBehavior
  }, props), {
    offscreenRoot
  }));
  if (!offscreenProps.active) {
    return __spreadProps(__spreadValues({}, offscreenProps), {
      children: value,
      role: getPopupItemRole(listElement),
      "aria-disabled": disabled || void 0,
      "data-offscreen-id": storeId
    });
  }
  return offscreenProps;
}
var CompositeItem2 = forwardRef(function CompositeItem3(_a) {
  var _b = _a, {
    offscreenBehavior,
    offscreenRoot
  } = _b, props = __objRest(_b, [
    "offscreenBehavior",
    "offscreenRoot"
  ]);
  const _a2 = useCompositeItemOffscreen(__spreadValues({
    offscreenBehavior,
    offscreenRoot
  }, props)), { active, ref } = _a2, rest = __objRest(_a2, ["active", "ref"]);
  const allProps = __spreadProps(__spreadValues(__spreadValues({}, rest), props), { ref: useMergeRefs(ref, props.ref) });
  if (active) {
    return /* @__PURE__ */ jsx(CompositeItem, __spreadValues({}, allProps));
  }
  const _b2 = allProps, {
    store,
    rowId,
    preventScrollOnKeyDown,
    moveOnKeyPress,
    tabbable,
    getItem
  } = _b2, htmlProps = __objRest(_b2, [
    "store",
    "rowId",
    "preventScrollOnKeyDown",
    "moveOnKeyPress",
    "tabbable",
    "getItem"
  ]);
  const Component = Role[TagName];
  return /* @__PURE__ */ jsx(Component, __spreadValues({}, htmlProps));
});

export {
  useCompositeItemOffscreen,
  CompositeItem2 as CompositeItem
};
