"use client";
import {
  useCommand
} from "./2W3RN7C5.js";
import {
  createElement,
  createHook,
  forwardRef
} from "./VOQWLFSQ.js";
import {
  useMergeRefs,
  useTagName
} from "./5GGHRIN3.js";
import {
  __spreadProps,
  __spreadValues
} from "./3YLGPPWQ.js";

// src/button/button.tsx
import { isButton } from "@ariakit/core/utils/dom";
import { useEffect, useRef, useState } from "react";
var TagName = "button";
var useButton = createHook(
  function useButton2(props) {
    const ref = useRef(null);
    const tagName = useTagName(ref, TagName);
    const [isNativeButton, setIsNativeButton] = useState(
      () => !!tagName && isButton({ tagName, type: props.type })
    );
    useEffect(() => {
      if (!ref.current) return;
      setIsNativeButton(isButton(ref.current));
    }, []);
    props = __spreadProps(__spreadValues({
      role: !isNativeButton && tagName !== "a" ? "button" : void 0
    }, props), {
      ref: useMergeRefs(ref, props.ref)
    });
    props = useCommand(props);
    return props;
  }
);
var Button = forwardRef(function Button2(props) {
  const htmlProps = useButton(props);
  return createElement(TagName, htmlProps);
});

export {
  useButton,
  Button
};
