"use client";
import {
  CheckboxCheckedContext
} from "./EYKMH5G5.js";
import {
  createElement,
  createHook,
  forwardRef
} from "./VOQWLFSQ.js";
import {
  __objRest,
  __spreadProps,
  __spreadValues
} from "./3YLGPPWQ.js";

// src/checkbox/checkbox-check.tsx
import { removeUndefinedValues } from "@ariakit/core/utils/misc";
import { useContext } from "react";
import { jsx } from "react/jsx-runtime";
var TagName = "span";
var checkmark = /* @__PURE__ */ jsx(
  "svg",
  {
    display: "block",
    fill: "none",
    stroke: "currentColor",
    strokeLinecap: "round",
    strokeLinejoin: "round",
    strokeWidth: 1.5,
    viewBox: "0 0 16 16",
    height: "1em",
    width: "1em",
    children: /* @__PURE__ */ jsx("polyline", { points: "4,8 7,12 12,4" })
  }
);
function getChildren(props) {
  if (props.checked) {
    return props.children || checkmark;
  }
  if (typeof props.children === "function") {
    return props.children;
  }
  return null;
}
var useCheckboxCheck = createHook(
  function useCheckboxCheck2(_a) {
    var _b = _a, { store, checked } = _b, props = __objRest(_b, ["store", "checked"]);
    const context = useContext(CheckboxCheckedContext);
    checked = checked != null ? checked : context;
    const children = getChildren({ checked, children: props.children });
    props = __spreadProps(__spreadValues({
      "aria-hidden": true
    }, props), {
      children,
      style: __spreadValues({
        width: "1em",
        height: "1em",
        pointerEvents: "none"
      }, props.style)
    });
    return removeUndefinedValues(props);
  }
);
var CheckboxCheck = forwardRef(function CheckboxCheck2(props) {
  const htmlProps = useCheckboxCheck(props);
  return createElement(TagName, htmlProps);
});

export {
  useCheckboxCheck,
  CheckboxCheck
};
