"use client";
import {
  useMergeRefs
} from "./5GGHRIN3.js";
import {
  getRefProperty,
  mergeProps
} from "./SK3NAZA3.js";
import {
  __objRest,
  __spreadProps,
  __spreadValues
} from "./3YLGPPWQ.js";

// src/utils/system.tsx
import * as React from "react";
import { jsx } from "react/jsx-runtime";
function forwardRef2(render) {
  const Role = React.forwardRef((props, ref) => render(__spreadProps(__spreadValues({}, props), { ref })));
  Role.displayName = render.displayName || render.name;
  return Role;
}
function memo2(Component, propsAreEqual) {
  return React.memo(Component, propsAreEqual);
}
function createElement(Type, props) {
  const _a = props, { wrapElement, render } = _a, rest = __objRest(_a, ["wrapElement", "render"]);
  const mergedRef = useMergeRefs(props.ref, getRefProperty(render));
  let element;
  if (React.isValidElement(render)) {
    const renderProps = __spreadProps(__spreadValues({}, render.props), { ref: mergedRef });
    element = React.cloneElement(render, mergeProps(rest, renderProps));
  } else if (render) {
    element = render(rest);
  } else {
    element = /* @__PURE__ */ jsx(Type, __spreadValues({}, rest));
  }
  if (wrapElement) {
    return wrapElement(element);
  }
  return element;
}
function createHook(useProps) {
  const useRole = (props = {}) => {
    return useProps(props);
  };
  useRole.displayName = useProps.name;
  return useRole;
}
function createStoreContext(providers = [], scopedProviders = []) {
  const context = React.createContext(void 0);
  const scopedContext = React.createContext(void 0);
  const useContext2 = () => React.useContext(context);
  const useScopedContext = (onlyScoped = false) => {
    const scoped = React.useContext(scopedContext);
    const store = useContext2();
    if (onlyScoped) return scoped;
    return scoped || store;
  };
  const useProviderContext = () => {
    const scoped = React.useContext(scopedContext);
    const store = useContext2();
    if (scoped && scoped === store) return;
    return store;
  };
  const ContextProvider = (props) => {
    return providers.reduceRight(
      (children, Provider) => /* @__PURE__ */ jsx(Provider, __spreadProps(__spreadValues({}, props), { children })),
      /* @__PURE__ */ jsx(context.Provider, __spreadValues({}, props))
    );
  };
  const ScopedContextProvider = (props) => {
    return /* @__PURE__ */ jsx(ContextProvider, __spreadProps(__spreadValues({}, props), { children: scopedProviders.reduceRight(
      (children, Provider) => /* @__PURE__ */ jsx(Provider, __spreadProps(__spreadValues({}, props), { children })),
      /* @__PURE__ */ jsx(scopedContext.Provider, __spreadValues({}, props))
    ) }));
  };
  return {
    context,
    scopedContext,
    useContext: useContext2,
    useScopedContext,
    useProviderContext,
    ContextProvider,
    ScopedContextProvider
  };
}

export {
  forwardRef2 as forwardRef,
  memo2 as memo,
  createElement,
  createHook,
  createStoreContext
};
