"use client";
import {
  useStore,
  useStoreProps
} from "./RTNCFSKZ.js";
import {
  useUpdateEffect
} from "./5GGHRIN3.js";

// src/disclosure/disclosure-store.ts
import * as Core from "@ariakit/core/disclosure/disclosure-store";
function useDisclosureStoreProps(store, update, props) {
  useUpdateEffect(update, [props.store, props.disclosure]);
  useStoreProps(store, props, "open", "setOpen");
  useStoreProps(store, props, "mounted", "setMounted");
  useStoreProps(store, props, "animated");
  return Object.assign(store, { disclosure: props.disclosure });
}
function useDisclosureStore(props = {}) {
  const [store, update] = useStore(Core.createDisclosureStore, props);
  return useDisclosureStoreProps(store, update, props);
}

export {
  useDisclosureStoreProps,
  useDisclosureStore
};
