"use client";
import {
  useRadioContext
} from "./BGBYET7R.js";
import {
  useCompositeItem
} from "./SBSPVDDI.js";
import {
  useStoreState
} from "./RTNCFSKZ.js";
import {
  createElement,
  createHook,
  forwardRef,
  memo
} from "./VOQWLFSQ.js";
import {
  useEvent,
  useForceUpdate,
  useId,
  useMergeRefs,
  useTagName
} from "./5GGHRIN3.js";
import {
  __objRest,
  __spreadProps,
  __spreadValues
} from "./3YLGPPWQ.js";

// src/radio/radio.tsx
import {
  disabledFromProps,
  removeUndefinedValues
} from "@ariakit/core/utils/misc";
import { useEffect, useRef } from "react";
var TagName = "input";
function getIsChecked(value, storeValue) {
  if (storeValue === void 0) return;
  if (value != null && storeValue != null) {
    return storeValue === value;
  }
  return !!storeValue;
}
function isNativeRadio(tagName, type) {
  return tagName === "input" && (!type || type === "radio");
}
var useRadio = createHook(function useRadio2(_a) {
  var _b = _a, {
    store,
    name,
    value,
    checked
  } = _b, props = __objRest(_b, [
    "store",
    "name",
    "value",
    "checked"
  ]);
  const context = useRadioContext();
  store = store || context;
  const id = useId(props.id);
  const ref = useRef(null);
  const isChecked = useStoreState(
    store,
    (state) => checked != null ? checked : getIsChecked(value, state == null ? void 0 : state.value)
  );
  useEffect(() => {
    if (!id) return;
    if (!isChecked) return;
    const isActiveItem = (store == null ? void 0 : store.getState().activeId) === id;
    if (isActiveItem) return;
    store == null ? void 0 : store.setActiveId(id);
  }, [store, isChecked, id]);
  const onChangeProp = props.onChange;
  const tagName = useTagName(ref, TagName);
  const nativeRadio = isNativeRadio(tagName, props.type);
  const disabled = disabledFromProps(props);
  const [propertyUpdated, schedulePropertyUpdate] = useForceUpdate();
  useEffect(() => {
    const element = ref.current;
    if (!element) return;
    if (nativeRadio) return;
    if (isChecked !== void 0) {
      element.checked = isChecked;
    }
    if (name !== void 0) {
      element.name = name;
    }
    if (value !== void 0) {
      element.value = `${value}`;
    }
  }, [propertyUpdated, nativeRadio, isChecked, name, value]);
  const onChange = useEvent((event) => {
    if (disabled) {
      event.preventDefault();
      event.stopPropagation();
      return;
    }
    if ((store == null ? void 0 : store.getState().value) === value) return;
    if (!nativeRadio) {
      event.currentTarget.checked = true;
      schedulePropertyUpdate();
    }
    onChangeProp == null ? void 0 : onChangeProp(event);
    if (event.defaultPrevented) return;
    store == null ? void 0 : store.setValue(value);
  });
  const onClickProp = props.onClick;
  const onClick = useEvent((event) => {
    onClickProp == null ? void 0 : onClickProp(event);
    if (event.defaultPrevented) return;
    if (nativeRadio) return;
    onChange(event);
  });
  const onFocusProp = props.onFocus;
  const onFocus = useEvent((event) => {
    onFocusProp == null ? void 0 : onFocusProp(event);
    if (event.defaultPrevented) return;
    if (!nativeRadio) return;
    if (!store) return;
    const { moves, activeId } = store.getState();
    if (!moves) return;
    if (id && activeId !== id) return;
    onChange(event);
  });
  props = __spreadProps(__spreadValues({
    id,
    role: !nativeRadio ? "radio" : void 0,
    type: nativeRadio ? "radio" : void 0,
    "aria-checked": isChecked
  }, props), {
    ref: useMergeRefs(ref, props.ref),
    onChange,
    onClick,
    onFocus
  });
  props = useCompositeItem(__spreadValues({
    store,
    clickOnEnter: !nativeRadio
  }, props));
  return removeUndefinedValues(__spreadValues({
    name: nativeRadio ? name : void 0,
    value: nativeRadio ? value : void 0,
    checked: isChecked
  }, props));
});
var Radio = memo(
  forwardRef(function Radio2(props) {
    const htmlProps = useRadio(props);
    return createElement(TagName, htmlProps);
  })
);

export {
  useRadio,
  Radio
};
