"use client";
import {
  useCollectionStoreProps
} from "./AMMIPFT4.js";
import {
  useStore,
  useStoreProps
} from "./RTNCFSKZ.js";
import {
  useEvent
} from "./5GGHRIN3.js";
import {
  __spreadProps,
  __spreadValues
} from "./3YLGPPWQ.js";

// src/form/form-store.ts
import * as Core from "@ariakit/core/form/form-store";
import { useCallback, useEffect, useMemo } from "react";
function useFormStoreProps(store, update, props) {
  store = useCollectionStoreProps(store, update, props);
  useStoreProps(store, props, "values", "setValues");
  useStoreProps(store, props, "errors", "setErrors");
  useStoreProps(store, props, "touched", "setTouched");
  const useValue = useCallback(
    (name) => store.useState(() => store.getValue(name)),
    [store]
  );
  const useValidate = useCallback(
    (callback) => {
      callback = useEvent(callback);
      const items = store.useState("items");
      useEffect(() => store.onValidate(callback), [items, callback]);
    },
    [store]
  );
  const useSubmit = useCallback(
    (callback) => {
      callback = useEvent(callback);
      const items = store.useState("items");
      useEffect(() => store.onSubmit(callback), [items, callback]);
    },
    [store]
  );
  return useMemo(
    () => __spreadProps(__spreadValues({}, store), {
      useValue,
      useValidate,
      useSubmit
    }),
    []
  );
}
function useFormStore(props = {}) {
  const [store, update] = useStore(Core.createFormStore, props);
  return useFormStoreProps(store, update, props);
}

export {
  useFormStoreProps,
  useFormStore
};
