"use client";
import {
  walkTreeOutside
} from "./AOUGVQZ3.js";
import {
  setAttribute
} from "./K2ZF5NU7.js";
import {
  isBackdrop
} from "./63XF7ACK.js";

// src/dialog/utils/disable-accessibility-tree-outside.ts
function hideElementFromAccessibilityTree(element) {
  return setAttribute(element, "aria-hidden", "true");
}
function disableAccessibilityTreeOutside(id, elements) {
  const cleanups = [];
  const ids = elements.map((el) => el == null ? void 0 : el.id);
  walkTreeOutside(id, elements, (element) => {
    if (isBackdrop(element, ...ids)) return;
    cleanups.unshift(hideElementFromAccessibilityTree(element));
  });
  const restoreAccessibilityTree = () => {
    for (const cleanup of cleanups) {
      cleanup();
    }
  };
  return restoreAccessibilityTree;
}

export {
  hideElementFromAccessibilityTree,
  disableAccessibilityTreeOutside
};
