"use client";
import {
  useVisuallyHidden
} from "./DXGKYUAD.js";
import {
  createElement,
  createHook,
  forwardRef
} from "./VOQWLFSQ.js";
import {
  __spreadProps,
  __spreadValues
} from "./3YLGPPWQ.js";

// src/focus-trap/focus-trap.tsx
var TagName = "span";
var useFocusTrap = createHook(
  function useFocusTrap2(props) {
    props = __spreadProps(__spreadValues({
      "data-focus-trap": "",
      tabIndex: 0,
      "aria-hidden": true
    }, props), {
      style: __spreadValues({
        // Prevents unintended scroll jumps.
        position: "fixed",
        top: 0,
        left: 0
      }, props.style)
    });
    props = useVisuallyHidden(props);
    return props;
  }
);
var FocusTrap = forwardRef(function FocusTrap2(props) {
  const htmlProps = useFocusTrap(props);
  return createElement(TagName, htmlProps);
});

export {
  useFocusTrap,
  FocusTrap
};
