"use client";
import {
  useDisclosureProviderContext
} from "./ABN76PSX.js";
import {
  useButton
} from "./XCKGTAUF.js";
import {
  createElement,
  createHook,
  forwardRef
} from "./VOQWLFSQ.js";
import {
  useBooleanEvent,
  useEvent,
  useMergeRefs,
  useMetadataProps
} from "./5GGHRIN3.js";
import {
  __objRest,
  __spreadProps,
  __spreadValues
} from "./3YLGPPWQ.js";

// src/disclosure/disclosure.tsx
import { invariant } from "@ariakit/core/utils/misc";
import { useEffect, useRef, useState } from "react";
var TagName = "button";
var symbol = Symbol("disclosure");
var useDisclosure = createHook(
  function useDisclosure2(_a) {
    var _b = _a, { store, toggleOnClick = true } = _b, props = __objRest(_b, ["store", "toggleOnClick"]);
    const context = useDisclosureProviderContext();
    store = store || context;
    invariant(
      store,
      process.env.NODE_ENV !== "production" && "Disclosure must receive a `store` prop or be wrapped in a DisclosureProvider component."
    );
    const ref = useRef(null);
    const [expanded, setExpanded] = useState(false);
    const disclosureElement = store.useState("disclosureElement");
    const open = store.useState("open");
    useEffect(() => {
      let isCurrentDisclosure = disclosureElement === ref.current;
      if (!(disclosureElement == null ? void 0 : disclosureElement.isConnected)) {
        store == null ? void 0 : store.setDisclosureElement(ref.current);
        isCurrentDisclosure = true;
      }
      setExpanded(open && isCurrentDisclosure);
    }, [disclosureElement, store, open]);
    const onClickProp = props.onClick;
    const toggleOnClickProp = useBooleanEvent(toggleOnClick);
    const [isDuplicate, metadataProps] = useMetadataProps(props, symbol, true);
    const onClick = useEvent((event) => {
      onClickProp == null ? void 0 : onClickProp(event);
      if (event.defaultPrevented) return;
      if (isDuplicate) return;
      if (!toggleOnClickProp(event)) return;
      store == null ? void 0 : store.setDisclosureElement(event.currentTarget);
      store == null ? void 0 : store.toggle();
    });
    const contentElement = store.useState("contentElement");
    props = __spreadProps(__spreadValues(__spreadValues({
      "aria-expanded": expanded,
      "aria-controls": contentElement == null ? void 0 : contentElement.id
    }, metadataProps), props), {
      ref: useMergeRefs(ref, props.ref),
      onClick
    });
    props = useButton(props);
    return props;
  }
);
var Disclosure = forwardRef(function Disclosure2(props) {
  const htmlProps = useDisclosure(props);
  return createElement(TagName, htmlProps);
});

export {
  useDisclosure,
  Disclosure
};
