"use client";
import {
  CompositeRowContext,
  useCompositeContext
} from "./APTFW6PT.js";
import {
  createElement,
  createHook,
  forwardRef
} from "./VOQWLFSQ.js";
import {
  useId,
  useWrapElement
} from "./5GGHRIN3.js";
import {
  __objRest,
  __spreadValues
} from "./3YLGPPWQ.js";

// src/composite/composite-row.tsx
import { invariant, removeUndefinedValues } from "@ariakit/core/utils/misc";
import { useMemo } from "react";
import { jsx } from "react/jsx-runtime";
var TagName = "div";
var useCompositeRow = createHook(
  function useCompositeRow2(_a) {
    var _b = _a, {
      store,
      "aria-setsize": ariaSetSize,
      "aria-posinset": ariaPosInSet
    } = _b, props = __objRest(_b, [
      "store",
      "aria-setsize",
      "aria-posinset"
    ]);
    const context = useCompositeContext();
    store = store || context;
    invariant(
      store,
      process.env.NODE_ENV !== "production" && "CompositeRow must be wrapped in a Composite component."
    );
    const id = useId(props.id);
    const baseElement = store.useState(
      (state) => state.baseElement || void 0
    );
    const providerValue = useMemo(
      () => ({ id, baseElement, ariaSetSize, ariaPosInSet }),
      [id, baseElement, ariaSetSize, ariaPosInSet]
    );
    props = useWrapElement(
      props,
      (element) => /* @__PURE__ */ jsx(CompositeRowContext.Provider, { value: providerValue, children: element }),
      [providerValue]
    );
    props = __spreadValues({ id }, props);
    return removeUndefinedValues(props);
  }
);
var CompositeRow = forwardRef(function CompositeRow2(props) {
  const htmlProps = useCompositeRow(props);
  return createElement(TagName, htmlProps);
});

export {
  useCompositeRow,
  CompositeRow
};
