"use client";
import {
  HeadingContext
} from "./CZ4GFWYL.js";
import {
  createElement,
  createHook,
  forwardRef
} from "./VOQWLFSQ.js";
import {
  useMergeRefs,
  useTagName
} from "./5GGHRIN3.js";
import {
  __spreadProps,
  __spreadValues
} from "./3YLGPPWQ.js";

// src/heading/heading.tsx
import { useContext, useMemo, useRef } from "react";
import { jsx } from "react/jsx-runtime";
var TagName = "h1";
var useHeading = createHook(
  function useHeading2(props) {
    const ref = useRef(null);
    const level = useContext(HeadingContext) || 1;
    const Element = `h${level}`;
    const tagName = useTagName(ref, Element);
    const isNativeHeading = useMemo(
      () => !!tagName && /^h\d$/.test(tagName),
      [tagName]
    );
    props = __spreadProps(__spreadValues({
      render: /* @__PURE__ */ jsx(Element, {}),
      role: !isNativeHeading ? "heading" : void 0,
      "aria-level": !isNativeHeading ? level : void 0
    }, props), {
      ref: useMergeRefs(ref, props.ref)
    });
    return props;
  }
);
var Heading = forwardRef(function Heading2(props) {
  const htmlProps = useHeading(props);
  return createElement(TagName, htmlProps);
});

export {
  useHeading,
  Heading
};
